/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.security;

import cpcn.dsp.institution.api.codec.Base64;
import cpcn.dsp.institution.api.system.CodeException;
import cpcn.dsp.institution.api.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;

public final class SecurityUtil {
    private static Logger logger = Logger.getLogger((String)"system");
    public static final String DIGEST_ALGORITHM_MD5 = "MD5";
    public static final String DIGEST_ALGORITHM_SHA1 = "SHA-1";
    public static final String SIGNATURE_ALGORITHM_MD5_WITH_RSA = "MD5withRSA";
    public static final String SIGNATURE_ALGORITHM_SHA1_WITH_RSA = "SHA1withRSA";
    public static final String SIGNATURE_ALGORITHM_SHA256_WITH_RSA = "SHA256withRSA";
    private static byte[] KEY_DATA = new byte[]{-28, -72, -83, -23, -121, -111, -26, -108, -81, -28, -69, -104, -26, -100, -119, -23, -103, -112, -27, -123, -84, -27, -113, -72};
    private static byte[] IV_DATA = new byte[]{67, 112, 99, 110, 49, 64, 51, 52};
    public static String[] SIGNATURE_ALGORITHMS_IN_USE = new String[]{"SHA1withRSA", "SHA256withRSA"};

    private SecurityUtil() {
    }

    public static PrivateKey getPrivateKeyFromPFX(String pfxfilename, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        FileInputStream fis = new FileInputStream(pfxfilename);
        keyStore.load(fis, password.toCharArray());
        fis.close();
        Enumeration<String> aliases = keyStore.aliases();
        String alias = aliases.nextElement();
        return (PrivateKey)keyStore.getKey(alias, password.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getPrivateKeyFromPFXForRSA(String pfxFileName, String pfxPassword) throws Exception {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(pfxFileName);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(fileInputStream, pfxPassword.toCharArray());
            String alias = null;
            Enumeration<String> aliases = keyStore.aliases();
            if (aliases.hasMoreElements()) {
                alias = aliases.nextElement();
            }
            Key key = keyStore.getKey(alias, pfxPassword.toCharArray());
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public static String getDecryptKeyByteByRSA(String signData, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, privateKey);
        byte[] output = cipher.doFinal(Base64.decode(signData));
        return StringUtil.bytes2hex(output);
    }

    public static byte[] digest(String message, String algorithm) throws Exception {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(message.getBytes("UTF-8"));
        return md.digest();
    }

    public static byte[] digest(String message) throws Exception {
        return SecurityUtil.digest(message, DIGEST_ALGORITHM_MD5);
    }

    public static X509Certificate generateCertificate(String base64stringParam) throws CertificateException, UnsupportedEncodingException {
        String base64string = base64stringParam;
        if (!base64string.startsWith("--")) {
            base64string = "-----BEGIN CERTIFICATE-----\n" + base64string + "\n-----END CERTIFICATE-----\n";
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(base64string.getBytes("UTF-8"));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(bais);
    }

    public static X509Certificate generateCertificate(String base64stringParam, String charset) throws CertificateException, UnsupportedEncodingException {
        String base64string = base64stringParam;
        if (!base64string.startsWith("--")) {
            base64string = "-----BEGIN CERTIFICATE-----\n" + base64string + "\n-----END CERTIFICATE-----\n";
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(base64string.getBytes(charset));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(bais);
    }

    public static X509Certificate generateCertificate(FileInputStream fis) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(fis);
    }

    public static KeyManager[] getKeyManagers(String keyStore, String keyStoreType, String keyStorePassword) throws Exception {
        String algorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        FileInputStream fis = new FileInputStream(keyStore);
        ks.load(fis, keyStorePassword.toCharArray());
        fis.close();
        kmf.init(ks, keyStorePassword.toCharArray());
        return kmf.getKeyManagers();
    }

    public static TrustManager[] getTrustManagers(String trustStore, String trustStoreType, String trustStorePassword) throws Exception {
        String algorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
        KeyStore keyStore = KeyStore.getInstance(trustStoreType);
        FileInputStream fileInputStream = new FileInputStream(trustStore);
        keyStore.load(fileInputStream, trustStorePassword.toCharArray());
        fileInputStream.close();
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }

    public static byte[] decryptRSAToByte(String encryptedDataBase64, PrivateKey privateKey) throws CodeException {
        if (StringUtil.isEmpty(encryptedDataBase64)) {
            throw new CodeException("", "\u5bc6\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == privateKey) {
            throw new CodeException("", "\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        byte[] plainBinary = null;
        try {
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            rsaCipher.init(2, privateKey);
            byte[] encodedBytes = Base64.decode(encryptedDataBase64);
            plainBinary = rsaCipher.doFinal(encodedBytes);
        }
        catch (Exception e) {
            logger.error((Object)"RSADecrypt Exception:- ", (Throwable)e);
        }
        return plainBinary;
    }

    public static String convertSignatureAlgorithm(String algorithmParam) {
        String algorithm = algorithmParam;
        String result = null;
        algorithm = StringUtil.trim(algorithm);
        for (String algorithmInUse : SIGNATURE_ALGORITHMS_IN_USE) {
            if (!algorithmInUse.equalsIgnoreCase(algorithm)) continue;
            result = algorithmInUse;
            break;
        }
        return result;
    }

    public static byte[] des3CBCDecrypt(byte[] ivData, byte[] keyData, byte[] cipherText) {
        SecretKeySpec key3Des = new SecretKeySpec(keyData, "DESede");
        IvParameterSpec ivSpec = new IvParameterSpec(ivData);
        byte[] plainText = null;
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            cipher.init(2, (Key)key3Des, ivSpec);
            plainText = cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            logger.error((Object)"DecryptCipher Exception:- ", (Throwable)e);
        }
        return plainText;
    }

    public static String des3CBCDecrypt(String cipherText) {
        String plainText = null;
        try {
            if (null != cipherText) {
                plainText = new String(SecurityUtil.des3CBCDecrypt(IV_DATA, KEY_DATA, StringUtil.hex2bytes(cipherText)));
            }
        }
        catch (Exception e) {
            logger.error((Object)"DecryptCipher Exception:- ", (Throwable)e);
        }
        return plainText;
    }

    public static byte[] des3CBCEncrypt(byte[] ivData, byte[] keyData, byte[] plainText) {
        SecretKeySpec key3Des = new SecretKeySpec(keyData, "DESede");
        IvParameterSpec ivSpec = new IvParameterSpec(ivData);
        byte[] cipherText = null;
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            cipher.init(1, (Key)key3Des, ivSpec);
            cipherText = cipher.doFinal(plainText);
        }
        catch (Exception e) {
            logger.error((Object)"EncryptCipher Exception:- ", (Throwable)e);
        }
        return cipherText;
    }

    public static String des3CBCEncrypt(String plainText) {
        String cipherText = null;
        try {
            if (null != plainText) {
                cipherText = StringUtil.bytes2hex(SecurityUtil.des3CBCEncrypt(IV_DATA, KEY_DATA, plainText.getBytes("UTF-8")));
            }
        }
        catch (Exception e) {
            logger.error((Object)"EncryptCipher Exception:- ", (Throwable)e);
        }
        return cipherText;
    }

    public static String encryptByRSA(String plainData, PublicKey publicKey) throws Exception {
        return SecurityUtil.encryptByRSA(plainData.getBytes("UTF-8"), publicKey);
    }

    public static String encryptByRSA(byte[] plainData, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, publicKey);
        byte[] output = cipher.doFinal(plainData);
        String encryptData = new String(Base64.encode(output));
        return encryptData;
    }
}

