/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.tx.personalinfo;

import com.alibaba.fastjson.JSONObject;
import cpcn.dsp.institution.api.tx.TxBaseResponse;
import cpcn.dsp.institution.api.util.JSONUtil;
import cpcn.dsp.institution.api.vo.court.Amount;
import cpcn.dsp.institution.api.vo.court.BreakFaithExecutor;
import cpcn.dsp.institution.api.vo.court.CourtAnnouncement;
import cpcn.dsp.institution.api.vo.court.ExecutedDefaulter;
import cpcn.dsp.institution.api.vo.court.HearingAnnouncement;
import cpcn.dsp.institution.api.vo.court.JudgementDocument;
import cpcn.dsp.institution.api.vo.court.TrialProcedures;
import java.util.ArrayList;
import java.util.List;

public class Tx2215Response
extends TxBaseResponse {
    private String institutionID;
    private String txSN;
    private String traceNo;
    private String responseCode;
    private String responseMessage;
    private String status;
    private List<Amount> amountList;
    private List<ExecutedDefaulter> executedDefaulterList;
    private List<BreakFaithExecutor> breakFaithExecutorList;
    private List<CourtAnnouncement> courtAnnouncementList;
    private List<HearingAnnouncement> hearingAnnouncementList;
    private List<JudgementDocument> judgementDocumentList;
    private List<TrialProcedures> trialProceduresList;

    public Tx2215Response(String responseMessage, String responseSignature) throws Exception {
        super(responseMessage, responseSignature);
    }

    public Tx2215Response(String responseMessage, String responseSignature, String responseDgtlEnvlp, String responseSignSN, String responseEncryptSN) throws Exception {
        super(responseMessage, responseSignature, responseDgtlEnvlp, responseSignSN, responseEncryptSN);
    }

    @Override
    protected void process(String document) throws Exception {
        if ("2000".equals(this.code)) {
            JSONObject jsonObject = JSONObject.parseObject((String)document);
            this.institutionID = jsonObject.getString("InstitutionID");
            this.txSN = jsonObject.getString("TxSN");
            this.traceNo = jsonObject.getString("TraceNo");
            this.responseCode = jsonObject.getString("ResponseCode");
            this.responseMessage = jsonObject.getString("ResponseMessage");
            this.status = jsonObject.getString("Status");
            this.amountList = this.processAmountList(jsonObject);
            this.executedDefaulterList = this.processExecutedDefaulterList(jsonObject);
            this.breakFaithExecutorList = this.processBreakFaithExecutorList(jsonObject);
            this.hearingAnnouncementList = this.processHearingAnnouncementList(jsonObject);
            this.courtAnnouncementList = this.processCourtAnnouncementList(jsonObject);
            this.judgementDocumentList = this.processJudgementDocumentList(jsonObject);
            this.trialProceduresList = this.processTrialProcedureList(jsonObject);
        }
    }

    private List<TrialProcedures> processTrialProcedureList(JSONObject jsonObject) {
        return (ArrayList)JSONUtil.toList(jsonObject.getString("TrialProceduresList"), TrialProcedures.class);
    }

    private List<JudgementDocument> processJudgementDocumentList(JSONObject jsonObject) {
        return (ArrayList)JSONUtil.toList(jsonObject.getString("JudgementDocumentList"), JudgementDocument.class);
    }

    private List<CourtAnnouncement> processCourtAnnouncementList(JSONObject jsonObject) {
        return (ArrayList)JSONUtil.toList(jsonObject.getString("CourtAnnouncementList"), CourtAnnouncement.class);
    }

    private List<HearingAnnouncement> processHearingAnnouncementList(JSONObject jsonObject) {
        return (ArrayList)JSONUtil.toList(jsonObject.getString("HearingAnnouncementList"), HearingAnnouncement.class);
    }

    private List<BreakFaithExecutor> processBreakFaithExecutorList(JSONObject jsonObject) {
        return (ArrayList)JSONUtil.toList(jsonObject.getString("BreakFaithExecutorList"), BreakFaithExecutor.class);
    }

    private List<ExecutedDefaulter> processExecutedDefaulterList(JSONObject jsonObject) {
        return (ArrayList)JSONUtil.toList(jsonObject.getString("ExecutedDefaulterList"), ExecutedDefaulter.class);
    }

    private List<Amount> processAmountList(JSONObject jsonObject) {
        return (ArrayList)JSONUtil.toList(jsonObject.getString("AmountList"), Amount.class);
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public void setInstitutionID(String institutionID) {
        this.institutionID = institutionID;
    }

    public String getTxSN() {
        return this.txSN;
    }

    public void setTxSN(String txSN) {
        this.txSN = txSN;
    }

    public String getTraceNo() {
        return this.traceNo;
    }

    public void setTraceNo(String traceNo) {
        this.traceNo = traceNo;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<Amount> getAmountList() {
        return this.amountList;
    }

    public void setAmountList(List<Amount> amountList) {
        this.amountList = amountList;
    }

    public List<ExecutedDefaulter> getExecutedDefaulterList() {
        return this.executedDefaulterList;
    }

    public void setExecutedDefaulterList(List<ExecutedDefaulter> executedDefaulterList) {
        this.executedDefaulterList = executedDefaulterList;
    }

    public List<BreakFaithExecutor> getBreakFaithExecutorList() {
        return this.breakFaithExecutorList;
    }

    public void setBreakFaithExecutorList(List<BreakFaithExecutor> breakFaithExecutorList) {
        this.breakFaithExecutorList = breakFaithExecutorList;
    }

    public List<CourtAnnouncement> getCourtAnnouncementList() {
        return this.courtAnnouncementList;
    }

    public void setCourtAnnouncementList(List<CourtAnnouncement> courtAnnouncementList) {
        this.courtAnnouncementList = courtAnnouncementList;
    }

    public List<HearingAnnouncement> getHearingAnnouncementList() {
        return this.hearingAnnouncementList;
    }

    public void setHearingAnnouncementList(List<HearingAnnouncement> hearingAnnouncementList) {
        this.hearingAnnouncementList = hearingAnnouncementList;
    }

    public List<JudgementDocument> getJudgementDocumentList() {
        return this.judgementDocumentList;
    }

    public void setJudgementDocumentList(List<JudgementDocument> judgementDocumentList) {
        this.judgementDocumentList = judgementDocumentList;
    }

    public List<TrialProcedures> getTrialProceduresList() {
        return this.trialProceduresList;
    }

    public void setTrialProceduresList(List<TrialProcedures> trialProceduresList) {
        this.trialProceduresList = trialProceduresList;
    }
}

