/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.link.jni;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.link.ICryptoLinkCommon;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.system.logging.LoggerManager;
import cryptokit.jni.JNISDF;
import java.io.File;

final class CryptoLinkCommonImp
implements ICryptoLinkCommon {
    private final JNISDF jnisdf;
    private final long warningTimeThreshold;
    private final boolean supportIdleTest;

    CryptoLinkCommonImp(JNISDF jnisdf, long warningTimeThreshold, boolean supportIdleTest) {
        this.jnisdf = jnisdf;
        this.warningTimeThreshold = warningTimeThreshold;
        this.supportIdleTest = supportIdleTest;
    }

    JNISDF getJnisdf() {
        return this.jnisdf;
    }

    public void loadSDFLib(String sdfLibPath) throws CryptoException {
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpMGR loadSDFLib Running: sdfLibPath={}", (Object)sdfLibPath);
        if (sdfLibPath == null) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR loadSDFLib failed: param sdfLibPath is null");
            throw new CryptoException("CryptoNativeImpMGR loadSDFLib failed: param sdfLibPath is null");
        }
        File p11File = new File(sdfLibPath);
        if (!p11File.exists()) {
            String warning = "CryptoNativeImpMGR loadSDFLib failed: file " + p11File.getAbsolutePath() + " is not exists!";
            LoggerManager.exceptionLogger.error(warning);
            throw new CryptoException(warning);
        }
        if (!p11File.isFile()) {
            String warning = "CryptoNativeImpMGR loadSDFLib failed: file " + p11File.getAbsolutePath() + " is not file!";
            LoggerManager.exceptionLogger.error(warning);
            throw new CryptoException(warning);
        }
        try {
            this.jnisdf.loadSDFLib(sdfLibPath);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR loadSDFLib failed", e);
            throw new CryptoException("CryptoNativeImpMGR loadSDFLib failed", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpMGR loadSDFLib finished, costTime={}", (Object)costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpMGR loadSDFLib accomplished, costTime={}", (Object)costTime);
        }
    }

    public void unloadLib() throws CryptoException {
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpMGR unloadLib Running");
        try {
            this.jnisdf.unloadLib();
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR unloadLib failed", e);
            throw new CryptoException("CryptoNativeImpMGR unloadLib failed", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpMGR unloadLib finished, costTime={}", (Object)costTime);
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpMGR unloadLib accomplished, costTime={}", (Object)costTime);
        }
    }

    public long openDevice() throws CryptoException {
        long deviceHandle;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpMGR openDevice Running");
        try {
            deviceHandle = this.jnisdf.openDevice();
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR openDevice failed", e);
            throw new CryptoException("CryptoNativeImpMGR openDevice failed", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpMGR openDevice finished, costTime={},deviceHandle={}", (Object)costTime, (Object)NumberHelper.hex(deviceHandle));
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpMGR openDevice accomplished, costTime={},deviceHandle={}", (Object)costTime, (Object)NumberHelper.hex(deviceHandle));
        }
        return this.checkHandle("deviceHandle", deviceHandle);
    }

    public int closeDevice(long deviceHandle) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpMGR closeDevice Running: deviceHandle={}", (Object)NumberHelper.hex(deviceHandle));
        try {
            returnResult = this.jnisdf.closeDevice(this.checkHandle("deviceHandle", deviceHandle));
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR closeDevice failed, deviceHandle={}", (Object)NumberHelper.hex(deviceHandle), (Object)e);
            throw new CryptoException("CryptoNativeImpMGR closeDevice failed", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpMGR closeDevice finished, costTime={},deviceHandle={},returnResult={}", new Object[]{costTime, NumberHelper.hex(deviceHandle), returnResult});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpMGR closeDevice accomplished, costTime={},deviceHandle={},returnResult={}", new Object[]{costTime, NumberHelper.hex(deviceHandle), returnResult});
        }
        return returnResult;
    }

    public long openSession(long deviceHandle) throws CryptoException {
        long sessionHandle;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpMGR openSession Running: deviceHandle={}", (Object)NumberHelper.hex(deviceHandle));
        try {
            sessionHandle = this.jnisdf.openSession(deviceHandle);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR openSession failed, deviceHandle={}", (Object)NumberHelper.hex(deviceHandle), (Object)e);
            throw new CryptoException("CryptoNativeImpMGR openSession failed", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpMGR openSession finished, costTime={},deviceHandle={},sessionHandle={}", new Object[]{costTime, NumberHelper.hex(deviceHandle), sessionHandle});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpMGR openSession accomplished, costTime={},deviceHandle={},sessionHandle={}", new Object[]{costTime, NumberHelper.hex(deviceHandle), sessionHandle});
        }
        return this.checkHandle("sessionHandle", sessionHandle);
    }

    public int closeSession(long sessionHandle) throws CryptoException {
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpMGR closeSession Running: sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
        try {
            returnResult = this.jnisdf.closeSession(sessionHandle);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR closeSession failed, sessionHandle={}", (Object)NumberHelper.hex(sessionHandle), (Object)e);
            throw new CryptoException("CryptoNativeImpMGR closeSession failed", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpMGR closeSession finished, costTime={},sessionHandle={},returnResult={}", new Object[]{costTime, NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult)});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpMGR closeSession accomplished, costTime={},sessionHandle={},returnResult={}", new Object[]{costTime, NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult)});
        }
        return returnResult;
    }

    public int getLoginStatus(long sessionHandle, byte[] pucStatus) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpMGR getLoginStatus Running: sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
        if (pucStatus == null || pucStatus.length < 1) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR getLoginStatus failed: param pucStatus is null/invalid");
            throw new CryptoException("CryptoNativeImpMGR getLoginStatus failed: param pucStatus is null/invalid");
        }
        try {
            returnResult = this.jnisdf.getLoginStatus(sessionHandle, pucStatus);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR getLoginStatus failed, sessionHandle={}", (Object)NumberHelper.hex(sessionHandle), (Object)e);
            throw new CryptoException("CryptoNativeImpMGR getLoginStatus failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR getLoginStatus failed, sessionHandle={},returnResult={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnResult));
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpMGR getLoginStatus finished,sessionHandle={},returnResult={},costTime={}, pucStatus[0]={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, pucStatus[0]});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpMGR getLoginStatus accomplished,sessionHandle={},returnResult={},costTime={}, pucStatus[0]={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, pucStatus[0]});
        }
        return returnResult;
    }

    public int getDeviceInfo(long sessionHandle, byte[] deviceInfo) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpMGR getDeviceInfo Running: sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
        if (deviceInfo == null || deviceInfo.length < 21) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR getDeviceInfo failed: param deviceInfo is null/invalid");
            throw new CryptoException("CryptoNativeImpMGR getDeviceInfo failed: param deviceInfo is null/invalid");
        }
        try {
            returnResult = this.jnisdf.getDeviceInfo(sessionHandle, deviceInfo);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR getDeviceInfo failed, sessionHandle={}", (Object)NumberHelper.hex(sessionHandle), (Object)e);
            throw new CryptoException("CryptoNativeImpMGR getDeviceInfo failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR getDeviceInfo failed, sessionHandle={},returnResult={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnResult));
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpMGR getDeviceInfo finished,sessionHandle={},returnResult={},costTime={}, deviceInfo={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, Strings.fromByteArray(deviceInfo)});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpMGR getDeviceInfo accomplished, sessionHandle={},returnResult={},costTime={}, deviceInfo={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, Strings.fromByteArray(deviceInfo)});
        }
        return returnResult;
    }

    public int idleTest(long sessionHandle) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpMGR idleTest Running: sessionHandle={}", (Object)sessionHandle);
        try {
            returnResult = this.supportIdleTest ? this.jnisdf.idleTest(sessionHandle) : 0;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR idleTest failed, sessionHandle={}", (Object)sessionHandle, (Object)e);
            throw new CryptoException("CryptoNativeImpMGR idleTest failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR idleTest failed, sessionHandle={},returnResult={}", (Object)sessionHandle, (Object)returnResult);
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpMGR idleTest finished,sessionHandle={},returnResult={},costTime={}", new Object[]{sessionHandle, returnResult, costTime});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpMGR idleTest accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{sessionHandle, returnResult, costTime});
        }
        return returnResult;
    }

    long checkHandle(String handleName, long handle) throws CryptoException {
        if (handle == 0L) {
            LoggerManager.exceptionLogger.error("checkHandle failed with invalid {}={}", (Object)handleName, (Object)handle);
            throw new CryptoException(String.format("invalid %s=%d", handleName, handle));
        }
        return handle;
    }

    public int getSNAndHwVersion(Long sessionHandle, byte[] devicesInfoOutput) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpMGR getSNAndHwVersion Running: sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
        if (devicesInfoOutput == null || devicesInfoOutput.length < 1024) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR getSNAndHwVersion failed: param deviceInfo is null/invalid");
            throw new CryptoException("CryptoNativeImpMGR getSNAndHwVersion failed: param deviceInfo is null/invalid");
        }
        try {
            returnResult = this.jnisdf.getSNAndHwVersion(sessionHandle.longValue(), devicesInfoOutput);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR getSNAndHwVersion failed, sessionHandle={}", (Object)NumberHelper.hex(sessionHandle), (Object)e);
            throw new CryptoException("CryptoNativeImpMGR getSNAndHwVersion failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpMGR getSNAndHwVersion failed, sessionHandle={},returnResult={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnResult));
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpMGR getSNAndHwVersion finished,sessionHandle={},returnResult={},costTime={}, deviceInfo={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, Strings.fromByteArray(devicesInfoOutput)});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpMGR getSNAndHwVersion accomplished, sessionHandle={},returnResult={},costTime={}, deviceInfo={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, Strings.fromByteArray(devicesInfoOutput)});
        }
        return returnResult;
    }
}

