/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.x509.CRLDistPoint;
import cfca.sadk.org.bouncycastle.asn1.x509.DistributionPoint;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.x509.certificate.X509CRL;
import cfca.sadk.x509.certificate.X509CRLFile;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.PublicKey;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public final class X509CertVerifier {
    private static Map<String, PublicKey> validTrustCerts = new ConcurrentHashMap<String, PublicKey>();
    private static final int maxTrustCerts = 20000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTrustCertsMap(String trustCertPath) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("updateTrustCertsMap[trustCertPath]>>>>>>Running: trustCert=" + validTrustCerts.size() + ", trustCerPath=" + trustCertPath);
        }
        X509Cert trustCer = null;
        try {
            trustCer = new X509Cert(trustCertPath);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("updateTrustCertsMap[trustCertPath]<<<<<<Failure: trustCertPath=" + trustCertPath);
            throw new PKIException("updateTrustCertsMap Failure with invalid content trustCertPath=" + trustCertPath);
        }
        try {
            X509CertVerifier.updateTrustCertsMap(trustCer);
        }
        finally {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("updateTrustCertsMap[trustCertPath]<<<<<<Finished: trustCert=" + validTrustCerts.size());
            }
        }
    }

    public static void updateTrustCertsMap(X509Cert[] trustCerts) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("updateTrustCertsMap[X509Certs]>>>>>>Running: trustCert=" + validTrustCerts.size());
        }
        if (trustCerts != null) {
            for (int i = 0; i < trustCerts.length; ++i) {
                X509CertVerifier.updateTrustCertsMap(trustCerts[i]);
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("updateTrustCertsMap[X509Certs]<<<<<<Finished: trustCert=" + validTrustCerts.size());
        }
    }

    public static void updateTrustCertsMap(X509Cert trustCert) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("updateTrustCertsMap[X509Cert]>>>>>>Running: trustCert=" + validTrustCerts.size());
            buffer.append(SADKDebugger.dump(trustCert));
        }
        if (X509CertVerifier.isValidAlgorithm(trustCert)) {
            X509CertVerifier.updateTrustCertsMapBySubjectName(trustCert);
            X509CertVerifier.updateTrustCertsMapByKeyIdentifier(trustCert);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("updateTrustCertsMap[X509Cert]<<<<<<Finished: trustCerts=" + validTrustCerts.size());
        }
    }

    public static void clearTrustCertsMap() {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("clearTrustCertsMap>>>>>>Running: trustCerts=" + validTrustCerts.size());
        }
        validTrustCerts.clear();
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("clearTrustCertsMap<<<<<<Finished: trustCerts=" + validTrustCerts.size());
        }
    }

    public static boolean clearTrustCertsMap(X509Cert trustCert) throws PKIException {
        LoggerManager.systemLogger.info("updateTrustCertsMap[X509Certs] clear");
        boolean clearResult = false;
        if (trustCert != null) {
            String id;
            String trustSN = trustCert.getStringSerialNumber();
            String dn = trustCert.getSubject();
            if (validTrustCerts.containsKey(dn)) {
                validTrustCerts.remove(dn);
                LoggerManager.systemLogger.info("clearTrustCertsMap: validTrustCerts={},  dn={} for SN={}", new Object[]{validTrustCerts.size(), dn, trustSN});
                clearResult = true;
            }
            if ((id = X509CertVerifier.buildId(trustCert)) != null && validTrustCerts.containsKey(id)) {
                validTrustCerts.remove(id);
                LoggerManager.systemLogger.info("clearTrustCertsMap: validTrustCerts={},  id={} for SN={}", new Object[]{validTrustCerts.size(), id, trustSN});
                clearResult = true;
            }
        }
        LoggerManager.systemLogger.info("updateTrustCertsMap[X509Certs] clearResult={}", (Object)clearResult);
        return clearResult;
    }

    public static boolean validateCertSign(X509Cert cert) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("validateCertSign>>>>>>Running: cert=" + cert);
        }
        try {
            if (cert == null) {
                throw new PKIException("validateCertSign Failure: null not allowed for parameter@cert");
            }
            PublicKey pubKey = X509CertVerifier.findTrustPublicKey(cert);
            if (pubKey == null) {
                throw new PKIException("validateCertSign Failure: can not get the user issuer's cert");
            }
            boolean verifyResult = cert.verify(pubKey);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("validateCertSign<<<<<<Finished: verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("validateCertSign<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("validateCertSign<<<<<<Failure", e);
            throw new PKIException("validateCertSign Failure: " + e.getMessage(), e);
        }
    }

    public static boolean verifyCertDate(X509Cert cert) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("verifyCertDate>>>>>>Running: cert=" + cert);
        }
        if (cert == null) {
            throw new SecurityException("verifyCertDate Failure: null not allowed for parameter@cert");
        }
        Date current = new Date();
        boolean okay = true;
        if (current.before(cert.getNotBefore()) || current.after(cert.getNotAfter())) {
            okay = false;
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("verifyCertDate<<<<<<Finished: okay=" + okay);
        }
        return okay;
    }

    public static boolean verifyCertByCRLOutLine(X509Cert cert, String crlPath) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("verifyCertByCRLOutLine>>>>>>Running: crlPath=" + crlPath + ",cert=" + cert);
        }
        if (cert == null) {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("verifyCertByCRLOutLine<<<<<<Finished: Required parameter cert");
            }
            throw new PKIException("verifyCertByCRLOutLine Failure: Required parameter cert");
        }
        boolean isValid = false;
        try {
            X509CRLFile crlFile = new X509CRLFile(crlPath, false);
            isValid = !crlFile.isRevoke(cert.getSerialNumber());
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("verifyCertByCRLOutLine<<<<<<Failure: decodedX509CRLFile ", e);
            throw new PKIException("verifyCertByCRLOutLine Failure when decoded X509CRLFile: " + e.getMessage(), e);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("verifyCertByCRLOutLine<<<<<<Finished: isValid=" + isValid);
        }
        return isValid;
    }

    public static String getCRLPointName(X509Cert cert) throws PKIException {
        String crl;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("getCRLPointName>>>>>>Running: cert=" + cert);
        }
        try {
            CRLDistPoint crlDistExt = cert.getCRLDistributionPoints();
            if (crlDistExt == null || crlDistExt.getDistributionPoints() == null) {
                throw new PKIException("850904", "\u7528\u6237\u8bc1\u4e66\u4e2d\u6ca1\u6709CRL\u9881\u53d1\u70b9\u4fe1\u606f");
            }
            int crlDistCount = crlDistExt.getDistributionPoints().length;
            crl = null;
            for (int i = 0; i < crlDistCount; ++i) {
                DistributionPoint crlName = crlDistExt.getDistributionPoints()[i];
                String crlPointName = crlName.getDistributionPoint().toString();
                if (crlPointName.indexOf("ldap://") == -1) continue;
                crl = crlPointName;
            }
            if (crl == null) {
                throw new PKIException("850904", "\u7528\u6237\u8bc1\u4e66\u4e2d\u6ca1\u6709CRL\u7684\u76ee\u5f55\u4fe1\u606f");
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getCRLPointName<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("getCRLPointName<<<<<<Failure", e);
            throw new PKIException("getCRLPointName Failure", e);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("getCRLPointName<<<<<<Finished: crl=" + crl);
        }
        return crl;
    }

    public static boolean verifyCertByLDAP(X509Cert cert) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("verifyCertByLDAP>>>>>>Running: cert=" + cert);
        }
        try {
            String crlPointName = X509CertVerifier.getCRLPointName(cert);
            if (crlPointName == null) {
                throw new PKIException("850904", "\u7528\u6237\u8bc1\u4e66\u4e2d\u6ca1\u6709CRL\u9881\u53d1\u70b9\u4fe1\u606f");
            }
            int ldapIndex = crlPointName.indexOf("ldap://");
            crlPointName = crlPointName.substring(ldapIndex + 7, crlPointName.length());
            ldapIndex = crlPointName.indexOf(":");
            String ip = crlPointName.substring(0, ldapIndex);
            crlPointName = crlPointName.substring(ldapIndex + 1, crlPointName.length());
            ldapIndex = crlPointName.indexOf("/");
            String port = crlPointName.substring(0, ldapIndex);
            crlPointName = crlPointName.substring(ldapIndex + 1, crlPointName.length());
            ldapIndex = crlPointName.indexOf("?");
            String dn = crlPointName.substring(0, ldapIndex);
            String cn = crlPointName.substring(crlPointName.indexOf("=") + 1, crlPointName.indexOf(","));
            X509CRL x509Crl = null;
            try {
                x509Crl = X509CertVerifier.downloadCRL(ip, port, dn, cn);
            }
            catch (Throwable ex) {
                throw new PKIException("850905", "\u4ece\u76ee\u5f55\u670d\u52a1\u5668\u4e0b\u8f7dCRL\u5931\u8d25", ex);
            }
            if (x509Crl != null) {
                boolean passed;
                boolean bl = passed = !x509Crl.isRevoke(cert.getSerialNumber());
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("verifyCertByLDAP<<<<<<Finished: passed=" + passed);
                }
                return passed;
            }
            throw new PKIException("850905", "\u4ece\u76ee\u5f55\u670d\u52a1\u5668\u4e0b\u8f7dCRL\u5931\u8d25");
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("verifyCertByLDAP<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("verifyCertByLDAP<<<<<<Failure", e);
            throw new PKIException("verifyCertByLDAP Failure", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509CRL downloadCRL(String ip, String port, String dn, String cn) throws Exception {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("downloadCRL::>>>>>>Running");
            buffer.append("\n ip: " + ip);
            buffer.append("\n port: " + port);
            buffer.append("\n dn: " + dn);
            buffer.append("\n cn: " + cn);
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        String ldapUrl = "ldap://" + ip + ":" + port;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("downloadCRL::::::::ldapUrl=" + ldapUrl);
        }
        try {
            InitialDirContext ctx = null;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", ldapUrl);
            env.put("java.naming.ldap.attributes.binary", "certificateRevocationList");
            try {
                ctx = new InitialDirContext(env);
            }
            catch (NamingException e) {
                throw new Exception("downloadCRL Failure when InitialDirContext: " + e.getMessage(), e);
            }
            SearchControls tConstraints = new SearchControls();
            tConstraints.setSearchScope(2);
            NamingEnumeration<SearchResult> tResults = null;
            String filter = "(&(objectclass=cRLDistributionPoint)(cn=" + cn + "))";
            Object[] attrs = new String[]{"certificateRevocationList;binary"};
            X509CRL crl = null;
            try {
                tResults = ctx.search(dn, filter, attrs, tConstraints);
                if (tResults != null && tResults.hasMore()) {
                    while (tResults.hasMore()) {
                        SearchResult tSearchRel = tResults.next();
                        Attributes allAttrs = tSearchRel.getAttributes();
                        Attribute attCRL = allAttrs.get("certificateRevocationList;binary");
                        byte[] bCRL = (byte[])attCRL.get(0);
                        crl = new X509CRL(bCRL);
                        bCRL = null;
                        attCRL = null;
                    }
                }
                ctx.close();
            }
            catch (Throwable e) {
                throw new Exception("downloadCRL Failure when download: " + e.getMessage(), e);
            }
            X509CRL x509CRL = crl;
            return x509CRL;
        }
        finally {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("downloadCRL::::::::ldapUrl=" + ldapUrl);
            }
        }
    }

    private static boolean isValidAlgorithm(X509Cert trustCert) {
        String keyTypeAlgorithmIdECC = "1.2.840.10045.2.1";
        String keyTypeAlgorithmIdRSA = "1.2.840.113549.1.1.1";
        boolean isValid = false;
        if (trustCert != null) {
            try {
                String publicKeyAlgorithmOID = trustCert.getPublicKeyAlgorithmOID();
                isValid = "1.2.840.10045.2.1".equals(publicKeyAlgorithmOID) || "1.2.840.113549.1.1.1".equals(publicKeyAlgorithmOID);
            }
            catch (Exception e) {
                isValid = false;
                LoggerManager.exceptionLogger.error("isValidAlgorithm::<<<<<<Failure: " + SADKDebugger.dump(trustCert), (Throwable)e);
            }
        }
        return isValid;
    }

    private static void updateTrustCertsMapBySubjectName(X509Cert trustCert) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("updateTrustCertsMapBySubjectName::>>>>>>Running: trustCerts=" + validTrustCerts.size());
        }
        if (trustCert != null) {
            if (validTrustCerts.size() > 20000) {
                LoggerManager.exceptionLogger.error("updateTrustCertsMapBySubjectName::<<<<<<Failure: validTrustCerts exceed maxTrustCerts=20000");
                throw new PKIException("updateTrustCertsMap Failure with validTrustCerts exceed maxTrustCerts=20000");
            }
            try {
                validTrustCerts.put(trustCert.getSubject(), trustCert.getPublicKey());
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("updateTrustCertsMapBySubjectName::<<<<<<Failure: " + SADKDebugger.dump(trustCert), (Throwable)e);
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("updateTrustCertsMapBySubjectName::<<<<<<Finished: trustCert=" + validTrustCerts.size());
        }
    }

    private static void updateTrustCertsMapByKeyIdentifier(X509Cert trustCert) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("updateTrustCertsMapByKeyIdentifier::>>>>>>Running: trustCerts=" + validTrustCerts.size());
        }
        if (trustCert != null) {
            String trustSN = trustCert.getStringSerialNumber();
            if (validTrustCerts.size() > 20000) {
                LoggerManager.exceptionLogger.error("updateTrustCertsMapByKeyIdentifier::<<<<<<Failure: validTrustCerts exceed maxTrustCerts=20000");
                throw new PKIException("updateTrustCertsMap Failure with validTrustCerts exceed maxTrustCerts=20000");
            }
            String id = X509CertVerifier.buildId(trustCert);
            if (id != null) {
                validTrustCerts.put(id, trustCert.getPublicKey());
                LoggerManager.systemLogger.info("updateTrustCertsMapByKeyIdentifier: id={} for {}, validTrustCerts={}", new Object[]{id, trustSN, validTrustCerts.size()});
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("updateTrustCertsMapByKeyIdentifier::<<<<<<Finished: trustCert=" + validTrustCerts.size());
        }
    }

    private static PublicKey findTrustPublicKey(X509Cert cert) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("findTrustPublicKey::>>>>>>Running: cert=" + SADKDebugger.dump(cert));
        }
        PublicKey pubKey = null;
        try {
            if (cert.getAuthorityKeyIdentifier() != null) {
                String id = Hex.toHexString(cert.getAuthorityKeyIdentifier().getKeyIdentifier());
                pubKey = validTrustCerts.get(id);
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("findTrustPublicKey::<<<<<<Failure find AuthorityKeyIdentifier: " + SADKDebugger.dump(cert), (Throwable)e);
        }
        if (pubKey == null) {
            pubKey = validTrustCerts.get(cert.getIssuer());
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("findTrustPublicKey::<<<<<<Finished: PublicKey=" + SADKDebugger.dump(pubKey));
        }
        return pubKey;
    }

    private static String buildId(X509Cert trustCert) {
        String id = null;
        try {
            if (trustCert != null && trustCert.getSubjectKeyIdentifier() != null) {
                id = Hex.toHexString(trustCert.getSubjectKeyIdentifier().getKeyIdentifier());
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("buildId failed ", (Throwable)e);
        }
        return id;
    }
}

