/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.math.ec;

import cfca.sadk.org.bouncycastle.math.ec.AbstractECMultiplier;
import cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.math.ec.PreCompInfo;
import cfca.sadk.org.bouncycastle.math.ec.Tnaf;
import cfca.sadk.org.bouncycastle.math.ec.WTauNafPreCompInfo;
import cfca.sadk.org.bouncycastle.math.ec.ZTauElement;
import java.math.BigInteger;

public class WTauNafMultiplier
extends AbstractECMultiplier {
    static final String PRECOMP_NAME = "bc_wtnaf";

    protected ECPoint multiplyPositive(ECPoint point, BigInteger k) {
        if (!(point instanceof ECPoint.F2m)) {
            throw new IllegalArgumentException("Only ECPoint.F2m can be used in WTauNafMultiplier");
        }
        ECPoint.F2m p = (ECPoint.F2m)point;
        ECCurve.F2m curve = (ECCurve.F2m)p.getCurve();
        int m = curve.getM();
        byte a = curve.getA().toBigInteger().byteValue();
        byte mu = curve.getMu();
        BigInteger[] s = curve.getSi();
        ZTauElement rho = Tnaf.partModReduction(k, m, a, s, mu, (byte)10);
        return this.multiplyWTnaf(p, rho, curve.getPreCompInfo(p, PRECOMP_NAME), a, mu);
    }

    private ECPoint.F2m multiplyWTnaf(ECPoint.F2m p, ZTauElement lambda, PreCompInfo preCompInfo, byte a, byte mu) {
        ZTauElement[] alpha = a == 0 ? Tnaf.alpha0 : Tnaf.alpha1;
        BigInteger tw = Tnaf.getTw(mu, 4);
        byte[] u = Tnaf.tauAdicWNaf(mu, lambda, (byte)4, BigInteger.valueOf(16L), tw, alpha);
        return WTauNafMultiplier.multiplyFromWTnaf(p, u, preCompInfo);
    }

    private static ECPoint.F2m multiplyFromWTnaf(ECPoint.F2m p, byte[] u, PreCompInfo preCompInfo) {
        ECPoint.F2m[] pu;
        ECCurve.F2m curve = (ECCurve.F2m)p.getCurve();
        byte a = curve.getA().toBigInteger().byteValue();
        if (preCompInfo == null || !(preCompInfo instanceof WTauNafPreCompInfo)) {
            pu = Tnaf.getPreComp(p, a);
            WTauNafPreCompInfo pre = new WTauNafPreCompInfo();
            pre.setPreComp(pu);
            curve.setPreCompInfo(p, PRECOMP_NAME, pre);
        } else {
            pu = ((WTauNafPreCompInfo)preCompInfo).getPreComp();
        }
        ECPoint.F2m q = (ECPoint.F2m)p.getCurve().getInfinity();
        for (int i = u.length - 1; i >= 0; --i) {
            q = Tnaf.tau(q);
            byte ui = u[i];
            if (ui == 0) continue;
            q = ui > 0 ? q.addSimple(pu[ui]) : q.subtractSimple(pu[-ui]);
        }
        return q;
    }
}

