/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.math.ec;

import cfca.sadk.org.bouncycastle.math.ec.Nat166;
import java.util.Random;

public abstract class Mod166 {
    public static int inverse32(int d) {
        int x = d;
        x *= 2 - d * x;
        x *= 2 - d * x;
        x *= 2 - d * x;
        x *= 2 - d * x;
        return x;
    }

    public static void invert(int[] p, int[] x, int[] z) {
        int len = p.length;
        if (Nat166.isZero(len, x)) {
            throw new IllegalArgumentException("'x' cannot be 0");
        }
        if (Nat166.isOne(len, x)) {
            System.arraycopy(x, 0, z, 0, len);
            return;
        }
        int[] u = Nat166.copy(len, x);
        int[] a = Nat166.create(len);
        a[0] = 1;
        int ac = 0;
        if ((u[0] & 1) == 0) {
            ac = Mod166.inversionStep(p, u, len, a, ac);
        }
        if (Nat166.isOne(len, u)) {
            Mod166.inversionResult(p, ac, a, z);
            return;
        }
        int[] v = Nat166.copy(len, p);
        int[] b = Nat166.create(len);
        int bc = 0;
        int uvLen = len;
        while (true) {
            if (u[uvLen - 1] == 0 && v[uvLen - 1] == 0) {
                --uvLen;
                continue;
            }
            if (Nat166.gte(uvLen, u, v)) {
                Nat166.subFrom(uvLen, v, u);
                ac += Nat166.subFrom(len, b, a) - bc;
                ac = Mod166.inversionStep(p, u, uvLen, a, ac);
                if (!Nat166.isOne(uvLen, u)) continue;
                Mod166.inversionResult(p, ac, a, z);
                return;
            }
            Nat166.subFrom(uvLen, u, v);
            bc += Nat166.subFrom(len, a, b) - ac;
            bc = Mod166.inversionStep(p, v, uvLen, b, bc);
            if (Nat166.isOne(uvLen, v)) break;
        }
        Mod166.inversionResult(p, bc, b, z);
    }

    public static int[] random(int[] p) {
        int len = p.length;
        Random rand = new Random();
        int[] s = Nat166.create(len);
        int m = p[len - 1];
        m |= m >>> 1;
        m |= m >>> 2;
        m |= m >>> 4;
        m |= m >>> 8;
        m |= m >>> 16;
        do {
            for (int i = 0; i != len; ++i) {
                s[i] = rand.nextInt();
            }
            int n = len - 1;
            s[n] = s[n] & m;
        } while (Nat166.gte(len, s, p));
        return s;
    }

    public static void add(int[] p, int[] x, int[] y, int[] z) {
        int len = p.length;
        int c = Nat166.add(len, x, y, z);
        if (c != 0) {
            Nat166.subFrom(len, p, z);
        }
    }

    public static void subtract(int[] p, int[] x, int[] y, int[] z) {
        int len = p.length;
        int c = Nat166.sub(len, x, y, z);
        if (c != 0) {
            Nat166.addTo(len, p, z);
        }
    }

    private static void inversionResult(int[] p, int ac, int[] a, int[] z) {
        if (ac < 0) {
            Nat166.add(p.length, a, p, z);
        } else {
            System.arraycopy(a, 0, z, 0, p.length);
        }
    }

    private static int inversionStep(int[] p, int[] u, int uLen, int[] x, int xc) {
        int len = p.length;
        int count = 0;
        while (u[0] == 0) {
            Nat166.shiftDownWord(uLen, u, 0);
            count += 32;
        }
        int zeroes = Integer.numberOfTrailingZeros(u[0]);
        if (zeroes > 0) {
            Nat166.shiftDownBits(uLen, u, zeroes, 0);
            count += zeroes;
        }
        for (int i = 0; i < count; ++i) {
            if ((x[0] & 1) != 0) {
                xc = xc < 0 ? (xc += Nat166.addTo(len, p, x)) : (xc += Nat166.subFrom(len, p, x));
            }
            Nat166.shiftDownBit(len, x, xc);
        }
        return xc;
    }
}

