/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec;

import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x9.X962Parameters;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECPoint;
import cfca.sadk.org.bouncycastle.asn1.x9.X9IntegerConverter;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import cfca.sadk.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPointEncoder;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.jce.spec.ECPrivateKeySpec;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.Enumeration;

public class BCECPrivateKey
implements ECPrivateKey,
PKCS12BagAttributeCarrier,
ECPointEncoder {
    private static final long serialVersionUID = -8798706350466059726L;
    private String algorithm = "SM2";
    private boolean withCompression;
    private transient BigInteger d;
    private transient ECParameterSpec ecSpec = SM2Params.sm2dhtest;
    private transient ProviderConfiguration configuration;
    private transient DERBitString publicKey;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier = new PKCS12BagAttributeCarrierImpl();

    protected BCECPrivateKey() {
    }

    public BCECPrivateKey(String algorithm, ECPrivateKeyParameters params, ECParameterSpec ecSpec) {
        this.algorithm = algorithm;
        this.d = params.getD();
        this.ecSpec = ecSpec;
        this.configuration = BouncyCastleProvider.CONFIGURATION;
    }

    BCECPrivateKey(ECPrivateKey key, ProviderConfiguration configuration) {
        this.d = key.getD();
        this.algorithm = key.getAlgorithm();
        this.ecSpec = key.getParameters();
        this.configuration = configuration;
    }

    public BCECPrivateKey(String algorithm, ECPrivateKeySpec spec, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.d = spec.getD();
        this.ecSpec = spec.getParams();
        this.configuration = configuration;
    }

    public BCECPrivateKey(String algorithm, ECPrivateKeyParameters params, BCECPublicKey pubKey, ECParameterSpec spec, ProviderConfiguration configuration) {
        ECDomainParameters dp = params.getParameters();
        this.algorithm = algorithm;
        this.d = params.getD();
        this.configuration = configuration;
        this.ecSpec = spec == null ? new ECParameterSpec(dp.getCurve(), dp.getG(), dp.getN(), dp.getH(), dp.getSeed()) : spec;
        this.publicKey = this.getPublicKeyDetails(pubKey);
    }

    public BCECPrivateKey(String algorithm, ECPrivateKeyParameters params, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.d = params.getD();
        this.ecSpec = null;
        this.configuration = configuration;
        if ("SM2".equals(algorithm)) {
            this.ecSpec = SM2Params.sm2ParameterSpec;
        }
    }

    public BCECPrivateKey(String algorithm, BCECPrivateKey key) {
        this.algorithm = algorithm;
        this.d = key.d;
        this.ecSpec = key.ecSpec;
        this.withCompression = key.withCompression;
        this.publicKey = key.publicKey;
        this.attrCarrier = key.attrCarrier;
        this.configuration = key.configuration;
    }

    public BCECPrivateKey(PrivateKeyInfo info, ProviderConfiguration configuration) {
        this.configuration = configuration;
        this.populateFromPrivKeyInfo(info);
    }

    BCECPrivateKey(String algorithm, PrivateKeyInfo info, ProviderConfiguration configuration) {
        this.configuration = configuration;
        this.populateFromPrivKeyInfo(info);
        this.algorithm = algorithm;
    }

    private void populateFromPrivKeyInfo(PrivateKeyInfo info) {
        ASN1Encodable obj;
        X962Parameters params = X962Parameters.getInstance(info.getPrivateKeyAlgorithm().getParameters());
        if (params.isNamedCurve()) {
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)params.getParameters();
            X9ECParameters ecP = ECUtil.getNamedCurveByOid(oid);
            this.ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName(oid), ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
        } else if (params.isImplicitlyCA()) {
            this.ecSpec = null;
        } else {
            X9ECParameters ecP = X9ECParameters.getInstance(params.getParameters());
            this.ecSpec = new ECParameterSpec(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
        }
        try {
            obj = info.parsePrivateKey();
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to parse private key");
        }
        if (obj instanceof ASN1Integer) {
            ASN1Integer derD = ASN1Integer.getInstance(obj);
            this.d = derD.getValue();
        } else {
            cfca.sadk.org.bouncycastle.asn1.sec.ECPrivateKey ec = cfca.sadk.org.bouncycastle.asn1.sec.ECPrivateKey.getInstance(obj);
            this.d = ec.getKey();
            this.publicKey = ec.getPublicKey();
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        X962Parameters params = null;
        if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
            ASN1ObjectIdentifier curveOid = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)this.ecSpec).getName());
            params = new X962Parameters(curveOid);
        } else if (this.ecSpec == null) {
            params = new X962Parameters(DERNull.INSTANCE);
        } else {
            ECParameterSpec p = this.ecSpec;
            ECPoint pG = p.getG().normalize();
            ECPoint g = pG.getCurve().createPoint(pG.getAffineXCoord().toBigInteger(), pG.getAffineYCoord().toBigInteger());
            X9ECParameters ecP = new X9ECParameters(p.getCurve(), g, p.getN(), p.getH(), p.getSeed());
            params = new X962Parameters(ecP);
        }
        cfca.sadk.org.bouncycastle.asn1.sec.ECPrivateKey keyStructure = this.publicKey != null ? new cfca.sadk.org.bouncycastle.asn1.sec.ECPrivateKey(this.getD(), this.publicKey, params) : new cfca.sadk.org.bouncycastle.asn1.sec.ECPrivateKey(this.getD(), params);
        try {
            PrivateKeyInfo info = this.algorithm.equals("ECGOST3410") ? new PrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, params), keyStructure) : new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), keyStructure);
            return KeyUtil.getEncodedPrivateKeyInfo(info);
        }
        catch (IOException e) {
            return null;
        }
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public ECParameterSpec getParameters() {
        return this.ecSpec;
    }

    public BigInteger getD() {
        return this.d;
    }

    public ECPoint getQ() {
        int qLength;
        if (this.publicKey == null) {
            return new FixedPointCombMultiplier().multiply(this.ecSpec.getG(), this.d);
        }
        byte[] data = this.publicKey.getBytes();
        ASN1OctetString key = new DEROctetString(data);
        if (data[0] == 4 && data[1] == data.length - 2 && (data[2] == 2 || data[2] == 3) && (qLength = new X9IntegerConverter().getByteLength(this.ecSpec.getCurve())) >= data.length - 3) {
            try {
                key = (ASN1OctetString)ASN1Primitive.fromByteArray(data);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("error recovering public key");
            }
        }
        X9ECPoint derQ = new X9ECPoint(this.ecSpec.getCurve(), key);
        return derQ.getPoint();
    }

    public void setBagAttribute(ASN1ObjectIdentifier oid, ASN1Encodable attribute) {
        this.attrCarrier.setBagAttribute(oid, attribute);
    }

    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier oid) {
        return this.attrCarrier.getBagAttribute(oid);
    }

    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return this.ecSpec;
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BCECPrivateKey)) {
            return false;
        }
        BCECPrivateKey other = (BCECPrivateKey)o;
        return this.getD().equals(other.getD()) && this.engineGetSpec().equals(other.engineGetSpec());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private DERBitString getPublicKeyDetails(BCECPublicKey pub) {
        try {
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(pub.getEncoded()));
            return info.getPublicKeyData();
        }
        catch (IOException e) {
            return null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.populateFromPrivKeyInfo(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(enc)));
        this.configuration = BouncyCastleProvider.CONFIGURATION;
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

