/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.format;

import cfca.sadk.lib.crypto.hard.format.SM2Decide;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Cipher;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.CompatibleConfig;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Signature;
import java.util.Arrays;
import javax.crypto.Cipher;

public final class SM2Format {
    private SM2Format() {
    }

    public static boolean signingFormat(Provider provider, KeyPair keypair) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("signingFormat::>>>>>>running");
            buffer.append("\n keypair: ");
            buffer.append(SADKDebugger.dump(keypair));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean asnFormat = false;
        if (keypair != null) {
            try {
                Signature signature = Signature.getInstance("SM2", provider);
                signature.initSign(keypair.getPrivate());
                signature.update(new byte[32]);
                byte[] signData = signature.sign();
                boolean bl = asnFormat = signData != null && signData.length > 64;
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("signingFormat::::::::Finished: asnFormat=" + asnFormat + ",signData=" + SADKDebugger.dump(signData));
                }
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("signingFormat::<<<<<<Failure: asnFormat limited for False", (Throwable)e);
                asnFormat = false;
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("signingFormat::<<<<<<Failure: asnFormat limited for False", e);
                asnFormat = false;
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("signingFormat::<<<<<<Finished: asnFormat=" + asnFormat);
        }
        return asnFormat;
    }

    public static int encryptFormat(Provider provider, KeyPair keypair) {
        int sm2FormatType = 1;
        if (CompatibleConfig.SM2CheckHardLibOriginEncryptOutFormat) {
            if (keypair != null) {
                byte[] sourceData = new byte[32];
                for (int i = 0; i < sourceData.length; ++i) {
                    sourceData[i] = 8;
                }
                try {
                    Cipher cipher = Cipher.getInstance("SM2", provider);
                    cipher.init(1, keypair.getPublic());
                    byte[] encryptData = cipher.doFinal(sourceData);
                    if (ASN1SM2Cipher.isASN1EncryptType(encryptData) && SM2Format.trySM2Decrypt(cipher, encryptData, sourceData, keypair, 1)) {
                        sm2FormatType = 1;
                        LoggerManager.systemLogger.info("encryptFormat::::::::Tried Finished: C1_C3_C2_WITH_ASN1");
                    } else if (encryptData.length - sourceData.length == 96) {
                        if (SM2Format.trySM2Decrypt(cipher, encryptData, sourceData, keypair, 16)) {
                            sm2FormatType = 16;
                            LoggerManager.systemLogger.info("encryptFormat::::::::Tried Finished: C1_C2_C3_WITHOUT_0x04");
                        } else if (SM2Format.trySM2Decrypt(cipher, encryptData, sourceData, keypair, 4)) {
                            sm2FormatType = 4;
                            LoggerManager.systemLogger.info("encryptFormat::::::::Tried Finished: C1_C3_C2_WITHOUT_0x04");
                        } else {
                            sm2FormatType = 16;
                            LoggerManager.systemLogger.warn("encryptFormat::::::::Others Finished: C1_C2_C3_WITHOUT_0x04: " + Hex.toHexString(encryptData));
                        }
                    } else {
                        sm2FormatType = 1;
                        LoggerManager.systemLogger.warn("encryptFormat::::::::Others Finished: C1_C3_C2_WITH_ASN1: " + Hex.toHexString(encryptData));
                    }
                }
                catch (Exception e) {
                    LoggerManager.exceptionLogger.error("encryptFormat::<<<<<<Failure: asnFormat limited for False", (Throwable)e);
                    sm2FormatType = 1;
                }
                catch (Throwable e) {
                    LoggerManager.exceptionLogger.error("encryptFormat::<<<<<<Failure: asnFormat limited for False", e);
                    sm2FormatType = 1;
                }
            }
            if (sm2FormatType != CompatibleConfig.SM2HardLibOriginEncryptOutFormat) {
                LoggerManager.systemLogger.warn("encryptFormat:: the config type is " + CompatibleConfig.SM2HardLibOriginEncryptOutFormat + ", but the real Type is " + sm2FormatType);
            }
            LoggerManager.systemLogger.warn("encryptFormat::<<<<<<Finished: sm2FormatType=" + sm2FormatType);
        } else {
            sm2FormatType = CompatibleConfig.SM2HardLibOriginEncryptOutFormat;
            LoggerManager.systemLogger.warn("encryptFormat::<<<<<<Finished: CompatibleConfig.SM2HardLibOriginEncryptOutFormat=" + sm2FormatType);
        }
        return sm2FormatType;
    }

    public static byte[] signedOutFormat(String mType, byte[] signData) {
        if (signData != null && SM2Decide.isSM2Type(mType)) {
            boolean systemLoggerEnabled = LoggerManager.systemLogger.isInfoEnabled();
            boolean dataChangedFlag = false;
            try {
                if (signData.length != 64) {
                    if (systemLoggerEnabled) {
                        LoggerManager.systemLogger.info("signedOutFormatSM2->signDataIn={}", (Object)SADKDebugger.dump(signData));
                    }
                    dataChangedFlag = true;
                    signData = new ASN1SM2Signature(signData).getRSRaw64Bytes();
                    if (systemLoggerEnabled) {
                        LoggerManager.debugLogger.info("signedOutFormat>>signDataOut=" + SADKDebugger.dump(signData));
                    }
                }
            }
            catch (SecurityException e) {
                LoggerManager.exceptionLogger.error("signedOutFormatSM2 failed:signData= {}", (Object)SADKDebugger.dump(signData), (Object)e);
                throw e;
            }
            if (dataChangedFlag && systemLoggerEnabled) {
                LoggerManager.systemLogger.info("signedOutFormatSM2->signDataOU={}", (Object)SADKDebugger.dump(signData));
            }
        }
        return signData;
    }

    public static byte[] signedInFormat(String mType, byte[] signData, boolean asn1Format) {
        if (signData != null && SM2Decide.isSM2Type(mType)) {
            boolean systemLoggerEnabled = LoggerManager.systemLogger.isInfoEnabled();
            boolean dataChangedFlag = false;
            try {
                if (asn1Format) {
                    if (signData.length == 64) {
                        if (systemLoggerEnabled) {
                            LoggerManager.systemLogger.info("signedInFormatSM2->signDataIn={}", (Object)SADKDebugger.dump(signData));
                        }
                        dataChangedFlag = true;
                        signData = new ASN1SM2Signature(signData).getEncoded();
                        if (systemLoggerEnabled) {
                            LoggerManager.systemLogger.info("signedInFormatSM2->signDataOut={}", (Object)SADKDebugger.dump(signData));
                        }
                    }
                } else if (signData.length != 64) {
                    if (systemLoggerEnabled) {
                        LoggerManager.systemLogger.info("signedInFormatSM2->signDataIn={}", (Object)SADKDebugger.dump(signData));
                    }
                    dataChangedFlag = true;
                    signData = new ASN1SM2Signature(signData).getRSRaw64Bytes();
                    if (systemLoggerEnabled) {
                        LoggerManager.systemLogger.info("signedInFormatSM2->signDataOut={}", (Object)SADKDebugger.dump(signData));
                    }
                }
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("signedInFormat::<<<<<<Failure: skip ->signDataIn={}", (Object)SADKDebugger.dump(signData), (Object)e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("signedInFormat::<<<<<<Failure: skip ->signDataIn={}", (Object)SADKDebugger.dump(signData), (Object)e);
            }
            if (dataChangedFlag && systemLoggerEnabled) {
                LoggerManager.systemLogger.info("signedInFormat->signDataOu={}", (Object)SADKDebugger.dump(signData));
            }
        }
        return signData;
    }

    public static byte[] sm2EncryptOutFormat(byte[] encryptedData, int sm2HardEncryptedType) {
        int sm2EncryptedOutType = CompatibleConfig.SM2OutputFormatEncryptedBytes;
        boolean systemLoggerEnabled = LoggerManager.systemLogger.isInfoEnabled();
        if (systemLoggerEnabled) {
            LoggerManager.systemLogger.info("sm2EncryptOutFormat->sm2HardEncryptedType={}, encryptedDataIn={}", (Object)sm2HardEncryptedType, (Object)SADKDebugger.dump(encryptedData));
        }
        boolean dataChangedFlag = false;
        if (sm2HardEncryptedType != sm2EncryptedOutType) {
            dataChangedFlag = true;
            try {
                ASN1SM2Cipher out = new ASN1SM2Cipher(encryptedData, sm2HardEncryptedType);
                encryptedData = out.getEncryptedBytes(sm2EncryptedOutType);
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("sm2EncryptOutFormat::<<<<<<Failure: skip setting encryptedData=" + SADKDebugger.dump(encryptedData), (Throwable)e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("sm2EncryptOutFormat::<<<<<<Failure: skip setting encryptedData=" + SADKDebugger.dump(encryptedData), e);
            }
        }
        if (dataChangedFlag && systemLoggerEnabled) {
            LoggerManager.systemLogger.info("sm2EncryptOutFormat->sm2HardEncryptedType={}, encryptedDataOu={}", (Object)sm2HardEncryptedType, (Object)SADKDebugger.dump(encryptedData));
        }
        return encryptedData;
    }

    public static byte[] sm2DecryptInFormat(byte[] encryptData, int sm2EncryptedType, int sm2EncryptFormatProviderType) {
        boolean systemLoggerEnabled = LoggerManager.systemLogger.isInfoEnabled();
        if (systemLoggerEnabled) {
            LoggerManager.systemLogger.info("sm2EncryptOutFormat->sm2EncryptedType={}, encryptedDataIn={}", (Object)sm2EncryptedType, (Object)SADKDebugger.dump(encryptData));
        }
        boolean dataChangedFlag = false;
        if (sm2EncryptedType != sm2EncryptFormatProviderType) {
            dataChangedFlag = true;
            try {
                ASN1SM2Cipher asn1EncryptedData = new ASN1SM2Cipher(encryptData, sm2EncryptedType);
                encryptData = asn1EncryptedData.getEncryptedBytes(sm2EncryptFormatProviderType);
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("sm2DecryptInFormat::<<<<<<Failure: skip setting encryptData=" + SADKDebugger.dump(encryptData), (Throwable)e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("sm2DecryptInFormat::<<<<<<Failure: skip setting encryptData=" + SADKDebugger.dump(encryptData), e);
            }
        }
        if (dataChangedFlag && systemLoggerEnabled) {
            LoggerManager.systemLogger.info("sm2EncryptOutFormat->sm2EncryptedType={}, encryptedDataOu={}", (Object)sm2EncryptedType, (Object)SADKDebugger.dump(encryptData));
        }
        return encryptData;
    }

    private static boolean trySM2Decrypt(Cipher cipher, byte[] encryptData, byte[] sourceData, KeyPair keypair, int trySM2Format) {
        boolean passed = false;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("encryptFormat::::::::Tried trySM2DecryptFormatType=" + trySM2Format);
        }
        try {
            ASN1SM2Cipher asn1 = new ASN1SM2Cipher(encryptData, trySM2Format);
            cipher.init(2, keypair.getPrivate());
            byte[] decryptData = cipher.doFinal(asn1.getEncryptedBytes(trySM2Format));
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("encryptFormat::::::::Tried  sourceData=" + Hex.toHexString(sourceData));
                LoggerManager.debugLogger.debug("encryptFormat::::::::Tried decryptData=" + Hex.toHexString(decryptData));
            }
            passed = Arrays.equals(sourceData, decryptData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("trySM2Decrypt::<<<<<<Failure  trySM2DecryptFormatType=" + trySM2Format, (Throwable)e);
            passed = false;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("trySM2Decrypt::<<<<<<Failure  trySM2DecryptFormatType=" + trySM2Format, e);
            passed = false;
        }
        return passed;
    }
}

