/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.encryptor;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.hard.encryptor.AbsEncryptor;
import cfca.sadk.lib.crypto.hard.format.SM2Format;
import cfca.sadk.lib.crypto.hard.format.SM2FormatKey;
import cfca.sadk.lib.crypto.hard.generator.InternalPrivateKey;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Cipher;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import javax.crypto.Cipher;

public final class SM2Encryptor
extends AbsEncryptor {
    protected SM2Encryptor(Provider provider, String mType, int sm2EncryptFormatProviderType) throws Exception {
        super(provider, mType, sm2EncryptFormatProviderType);
    }

    public byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws Exception {
        byte[] decryptBytes;
        block7: {
            if (!(key instanceof PrivateKey)) {
                throw new IllegalArgumentException("SM2Decrypt Required PrivateKey");
            }
            if (encryptData == null || encryptData.length < 96) {
                throw new IllegalArgumentException("SM2Decrypt Failure with encryptData shortage");
            }
            PrivateKey hardKey = this.formatPrivateKey((PrivateKey)key);
            Cipher cipher = Cipher.getInstance(this.mType, this.provider);
            decryptBytes = null;
            if (ASN1SM2Cipher.isASN1EncryptType(encryptData)) {
                decryptBytes = this.sm2DecryptASN1C1C3C2(cipher, hardKey, encryptData);
            } else {
                try {
                    decryptBytes = this.sm2DecryptRAWC1C3C2(cipher, hardKey, encryptData);
                }
                catch (Exception e) {
                    decryptBytes = this.sm2DecryptRAWC1C2C3(cipher, hardKey, encryptData);
                    if (decryptBytes != null) break block7;
                    throw new Exception("SM2Decrypt(C1C3C2 /C1C2C3 Failed)", e);
                }
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2Decrypt::<<<<<<Finished: decryptBytes=" + SADKDebugger.dump(decryptBytes));
        }
        return decryptBytes;
    }

    private final byte[] sm2DecryptASN1C1C3C2(Cipher cipher, PrivateKey hardKey, byte[] encryptData) throws Exception {
        LoggerManager.debugLogger.debug("SM2Decrypt::::::::ASN1(C1C3C2): Running");
        byte[] cardEncryptData = SM2Format.sm2DecryptInFormat(encryptData, 1, this.sm2EncryptFormatProviderType);
        cipher.init(2, hardKey);
        byte[] decryptBytes = cipher.doFinal(cardEncryptData);
        LoggerManager.debugLogger.debug("SM2Decrypt::::::::ASN1(C1C3C2): Finished");
        return decryptBytes;
    }

    private final byte[] sm2DecryptRAWC1C3C2(Cipher cipher, PrivateKey hardKey, byte[] encryptData) throws Exception {
        LoggerManager.debugLogger.debug("SM2Decrypt:::::::: RAW(C1C3C2): Running");
        byte[] cardEncryptData = SM2Format.sm2DecryptInFormat(encryptData, 4, this.sm2EncryptFormatProviderType);
        cipher.init(2, hardKey);
        byte[] decryptBytes = cipher.doFinal(cardEncryptData);
        LoggerManager.debugLogger.debug("SM2Decrypt:::::::: RAW(C1C3C2): Finished");
        return decryptBytes;
    }

    private final byte[] sm2DecryptRAWC1C2C3(Cipher cipher, PrivateKey hardKey, byte[] encryptData) throws Exception {
        LoggerManager.debugLogger.debug("SM2Decrypt:::::::: RAW(C1C2C3): Running");
        byte[] cardEncryptData = SM2Format.sm2DecryptInFormat(encryptData, 16, this.sm2EncryptFormatProviderType);
        cipher.init(2, hardKey);
        byte[] decryptBytes = cipher.doFinal(cardEncryptData);
        LoggerManager.debugLogger.debug("SM2Decrypt:::::::: RAW(C1C2C3): Finished");
        return decryptBytes;
    }

    PrivateKey formatPrivateKey(PrivateKey privateKey) throws Exception {
        PrivateKey jceKey = null;
        jceKey = privateKey instanceof InternalPrivateKey ? ((InternalPrivateKey)privateKey).getInternalPrivateKey() : SM2FormatKey.convertToProviderSM2PrivateKey(this.provider, privateKey);
        return jceKey;
    }

    PublicKey formatPublicKey(PublicKey publicKey) throws Exception {
        return SM2FormatKey.convertToProviderSM2PublicKey(this.provider, publicKey);
    }

    byte[] formatInputEncryptData(byte[] input) throws Exception {
        return input;
    }

    byte[] formatOutputEncryptData(byte[] output) throws Exception {
        return SM2Format.sm2EncryptOutFormat(output, this.sm2EncryptFormatProviderType);
    }

    public String getKeyType() {
        return "SM2";
    }
}

