/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200;

import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.lib.crypto.card.c200.CardKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import java.io.IOException;
import java.math.BigInteger;

public abstract class ECCCardKey
implements CardKey {
    final byte[] defaultZ;
    final long keyHandle;
    final byte[] pubKeyX;
    final byte[] pubKeyY;
    final BigInteger iPubX;
    final BigInteger iPubY;
    final String CKID;
    final int keyUsage;
    final boolean internal;

    public ECCCardKey(byte[] defaultZ, long keyHandle, byte[] pubKeyX, byte[] pubKeyY, String CKID, int keyUsage) {
        this.defaultZ = defaultZ == null ? new byte[]{} : defaultZ;
        this.keyHandle = keyHandle;
        this.pubKeyX = pubKeyX == null ? new byte[]{} : pubKeyX;
        this.pubKeyY = pubKeyY == null ? new byte[]{} : pubKeyY;
        this.iPubX = new BigInteger(1, this.pubKeyX);
        this.iPubY = new BigInteger(1, this.pubKeyY);
        this.CKID = CKID;
        this.keyUsage = keyUsage;
        this.internal = true;
    }

    public ECCCardKey(BCECPublicKey eccKey) throws IOException {
        this.defaultZ = new byte[0];
        this.keyHandle = -1L;
        this.iPubX = new BigInteger(1, eccKey.getQ().getX().getEncoded());
        this.iPubY = new BigInteger(1, eccKey.getQ().getY().getEncoded());
        this.pubKeyX = BigIntegerUtil.asUnsigned32ByteArray(this.iPubX);
        this.pubKeyY = BigIntegerUtil.asUnsigned32ByteArray(this.iPubY);
        this.CKID = "external";
        this.keyUsage = 0;
        this.internal = false;
    }

    public final byte[] getDefaultZ() {
        return this.defaultZ;
    }

    public final long getKeyHandle() {
        return this.keyHandle;
    }

    public byte[] getPubKeyX() {
        return this.pubKeyX;
    }

    public byte[] getPubKeyY() {
        return this.pubKeyY;
    }

    public String getAlgorithm() {
        return "ECC";
    }

    public String getFormat() {
        return "ECCard";
    }
}

