/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.asn1.pkcs;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.sm2.SM3Digest;
import cfca.sadk.algorithm.sm2.SM4Engine;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.BERSequence;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.crypto.DataLengthException;
import cfca.sadk.org.bouncycastle.crypto.InvalidCipherTextException;
import cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.global.SM2ContextConfig;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;

public class PKCS12_SM2
implements ASN1Encodable,
PKCSObjectIdentifiers {
    private ASN1Sequence privateInfo = null;
    private ASN1Sequence publicInfo = null;
    private SM2PrivateKey SM2PrivateKey;
    private X509Cert[] certs;

    public static PKCS12_SM2 getInstance(Object obj) throws PKIException {
        if (obj instanceof PKCS12_SM2) {
            return (PKCS12_SM2)obj;
        }
        if (obj instanceof byte[]) {
            return new PKCS12_SM2((byte[])obj);
        }
        if (obj != null) {
            return new PKCS12_SM2(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public PKCS12_SM2() {
    }

    public PKCS12_SM2(byte[] encoding) throws PKIException {
        if (encoding == null) {
            throw new PKIException("SM2File encoding should not be null");
        }
        this.load(encoding);
    }

    public PKCS12_SM2(ASN1Sequence seq) throws PKIException {
        this.parseSM2(seq);
    }

    public PKCS12_SM2(ASN1Sequence publicInfo, ASN1Sequence privateInfo) throws PKIException {
        if (publicInfo == null) {
            throw new PKIException("SM2File publicInfo should not be null");
        }
        if (privateInfo == null) {
            throw new PKIException("SM2File privateInfo should not be null");
        }
        this.parseSM2Certs(privateInfo, publicInfo);
    }

    public void load(byte[] data) throws PKIException {
        ASN1Sequence seq;
        try {
            seq = ASN1Parser.getDERSequenceFrom(data);
        }
        catch (Exception e) {
            throw new PKIException("SM2File Decoding failure", e);
        }
        this.parseSM2(seq);
    }

    public void parseSM2(ASN1Sequence seq) throws PKIException {
        if (seq == null || seq.size() != 3) {
            throw new PKIException("invalid SM2File encoding");
        }
        this.parseSM2Certs((ASN1Sequence)seq.getObjectAt(1), (ASN1Sequence)seq.getObjectAt(2));
    }

    private void parseSM2Certs(ASN1Sequence privateInfo, ASN1Sequence publicInfo) throws PKIException {
        if (privateInfo.size() != 3) {
            throw new PKIException("the sm2 file is not right format,can not get the private part");
        }
        if (publicInfo.size() != 2) {
            throw new PKIException("the sm2 file is not right format.can not get the public part");
        }
        this.privateInfo = privateInfo;
        this.publicInfo = publicInfo;
        ASN1OctetString pubOctString = (ASN1OctetString)publicInfo.getObjectAt(1);
        this.certs = new X509Cert[]{new X509Cert(pubOctString.getOctets())};
    }

    private static byte[] KDF(byte[] z) {
        byte[] ct = new byte[]{0, 0, 0, 1};
        SM3Digest sm3 = new SM3Digest();
        sm3.update(z, 0, z.length);
        sm3.update(ct, 0, ct.length);
        byte[] hash = new byte[32];
        sm3.doFinal(hash, 0);
        return hash;
    }

    public PrivateKey getPrivateKey() throws PKIException {
        if (this.SM2PrivateKey == null) {
            throw new PKIException(PKIException.DECRYPT_P12_ERR, PKIException.DECRYPT_P12_ERR_DES);
        }
        return this.SM2PrivateKey;
    }

    public SM2PrivateKey getPrivateKey(String password) throws PKIException {
        return this.decrypt(password);
    }

    public SM2PrivateKey decrypt(String password) throws PKIException {
        if (this.SM2PrivateKey == null) {
            byte[] encryptedData;
            if (password == null) {
                throw new PKIException("SM2File password should not be null");
            }
            if (this.privateInfo == null) {
                throw new PKIException("SM2File invalid : privateInfo=null");
            }
            ASN1OctetString priOctString = (ASN1OctetString)this.privateInfo.getObjectAt(2);
            try {
                encryptedData = priOctString.getOctets();
            }
            catch (Exception e) {
                throw new PKIException("SM2File decoding failure", e);
            }
            byte[] dBytes = this.SM4DecryptDBytes(password, encryptedData);
            X509Cert cert = this.getPublicCert()[0];
            SM2PublicKey pubKey = (SM2PublicKey)cert.getPublicKey();
            byte[] pubX = pubKey.getPubXByBytes();
            byte[] pubY = pubKey.getPubYByBytes();
            this.SM2PrivateKey = new SM2PrivateKey(dBytes, pubX, pubY);
        }
        return this.SM2PrivateKey;
    }

    private byte[] SM4DecryptDBytes(String password, byte[] encryptedData) throws PKIException {
        byte[] sm4;
        byte[] iv;
        byte[] passwordBytes;
        if (password == null || password.length() == 0) {
            throw new PKIException("SM2File password should not be null");
        }
        try {
            passwordBytes = password.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PKIException("SM2File password decoding failure", e);
        }
        if (encryptedData == null || encryptedData.length == 0) {
            throw new PKIException("SM2File encryptedData should not be null");
        }
        if (encryptedData.length < 32 || encryptedData.length > 64) {
            throw new PKIException("SM2File EncryptedData required length in [32-64] ");
        }
        byte[] encoding = null;
        if (encryptedData.length == 32 || encryptedData.length == 48) {
            encoding = encryptedData;
        } else {
            try {
                encoding = Base64.decode(encryptedData);
            }
            catch (Exception e) {
                throw new PKIException("SM2File EncryptedData required base64 ");
            }
        }
        try {
            byte[] hash = PKCS12_SM2.KDF(passwordBytes);
            iv = new byte[16];
            System.arraycopy(hash, 0, iv, 0, 16);
            sm4 = new byte[16];
            System.arraycopy(hash, 16, sm4, 0, 16);
        }
        catch (Exception e) {
            throw new PKIException("SM2File KDF failure", e);
        }
        try {
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(sm4), iv);
            cipher.init(false, params);
            int outLength = cipher.getOutputSize(encoding.length);
            byte[] out = new byte[outLength];
            int dataLength = cipher.processBytes(encoding, 0, encoding.length, out, 0);
            int lastLength = cipher.doFinal(out, dataLength);
            int realLength = dataLength + lastLength;
            byte[] dBytes = null;
            if (realLength < outLength) {
                dBytes = new byte[realLength];
                System.arraycopy(out, 0, dBytes, 0, realLength);
            } else {
                dBytes = out;
            }
            return dBytes;
        }
        catch (DataLengthException e) {
            throw new PKIException("SM2File SM2PrivateKey decrypt failure with IllegalDataLength", e);
        }
        catch (IllegalArgumentException e) {
            throw new PKIException("SM2File SM2PrivateKey decrypt failure with IllegalArgument", e);
        }
        catch (IllegalStateException e) {
            throw new PKIException("SM2File SM2PrivateKey decrypt failure with IllegalState", e);
        }
        catch (InvalidCipherTextException e) {
            throw new PKIException("SM2File SM2PrivateKey decrypt failure with InvalidCipherText", e);
        }
        catch (Exception e) {
            throw new PKIException("SM2File SM2PrivateKey decrypt failure", e);
        }
    }

    private static byte[] SM4EncryptDBytes(String password, byte[] privateKeyData) throws PKIException {
        byte[] sm4;
        byte[] iv;
        byte[] passwordBytes;
        if (password == null || password.length() == 0) {
            throw new PKIException("SM2File password should not be null");
        }
        try {
            passwordBytes = password.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PKIException("SM2File password decoding failure", e);
        }
        if (privateKeyData == null || privateKeyData.length == 0) {
            throw new PKIException("SM2File EncryptedData should not be null");
        }
        try {
            byte[] hash = PKCS12_SM2.KDF(passwordBytes);
            iv = new byte[16];
            System.arraycopy(hash, 0, iv, 0, 16);
            sm4 = new byte[16];
            System.arraycopy(hash, 16, sm4, 0, 16);
        }
        catch (Exception e) {
            throw new PKIException("SM2File KDF failure", e);
        }
        try {
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(sm4), iv);
            cipher.init(true, params);
            int outLength = cipher.getOutputSize(privateKeyData.length);
            byte[] out = new byte[outLength];
            int dataLength = cipher.processBytes(privateKeyData, 0, privateKeyData.length, out, 0);
            int lastLength = cipher.doFinal(out, dataLength);
            int realLength = dataLength + lastLength;
            byte[] encryptedData = null;
            if (realLength < outLength) {
                encryptedData = new byte[realLength];
                System.arraycopy(out, 0, encryptedData, 0, realLength);
            } else {
                encryptedData = out;
            }
            return encryptedData;
        }
        catch (DataLengthException e) {
            throw new PKIException("SM2File SM2PrivateKey encrypt failure with IllegalDataLength", e);
        }
        catch (IllegalArgumentException e) {
            throw new PKIException("SM2File SM2PrivateKey encrypt failure with IllegalArgument", e);
        }
        catch (IllegalStateException e) {
            throw new PKIException("SM2File SM2PrivateKey encrypt failure with IllegalState", e);
        }
        catch (InvalidCipherTextException e) {
            throw new PKIException("SM2File SM2PrivateKey encrypt failure with InvalidCipherText", e);
        }
        catch (Exception e) {
            throw new PKIException("SM2File SM2PrivateKey encrypt failure", e);
        }
    }

    public X509Cert[] getPublicCert() throws PKIException {
        if (this.certs == null) {
            throw new PKIException("SM2File invalid : certs=null");
        }
        return this.certs;
    }

    public ASN1Primitive toASN1Primitive() {
        if (this.privateInfo == null) {
            throw new IllegalArgumentException("SM2File privateInfo should not be null");
        }
        if (this.publicInfo == null) {
            throw new IllegalArgumentException("SM2File publicInfo should not be null");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(1L));
        v.add(this.privateInfo);
        v.add(this.publicInfo);
        return new BERSequence(v);
    }

    private static PKCS12_SM2 generateSM2(X509Cert x509Cert, PrivateKey privateKey, String password) throws PKIException {
        boolean verifyResult;
        if (password == null || password.length() == 0) {
            throw new PKIException("SM2File password should not be null");
        }
        if (privateKey == null) {
            throw new PKIException("SM2File privateKey should not be null");
        }
        if (x509Cert == null) {
            throw new PKIException("SM2File x509Cert should not be null");
        }
        SM2PrivateKey sm2PrvKey = null;
        if (!(privateKey instanceof SM2PrivateKey)) {
            throw new PKIException("SM2File privateKey must SM2PrivateKey");
        }
        sm2PrvKey = (SM2PrivateKey)privateKey;
        Session softLib = BCSoftLib.INSTANCE();
        Mechanism mechanism = new Mechanism("sm3WithSM2Encryption");
        byte[] sourceData = Strings.toByteArray("TESTING");
        try {
            byte[] signData = softLib.sign(mechanism, (PrivateKey)sm2PrvKey, sourceData);
            verifyResult = softLib.verify(mechanism, x509Cert.getPublicKey(), sourceData, signData);
        }
        catch (Exception e) {
            throw new PKIException("SM2File x509Cert/privateKey try signing failure", e);
        }
        if (!verifyResult) {
            throw new PKIException("SM2File x509Cert/privateKey not match");
        }
        byte[] dBytes = sm2PrvKey.getDByBytes();
        if (dBytes == null || dBytes.length != 32) {
            throw new PKIException("SM2File SM2PrivateKey format invalid");
        }
        byte[] encryptedData = PKCS12_SM2.SM4EncryptDBytes(password, sm2PrvKey.getDByBytes());
        try {
            ASN1EncodableVector publicInfoVector = new ASN1EncodableVector();
            publicInfoVector.add(PKCSObjectIdentifiers.sm2Data);
            DEROctetString pubDEROctetString = new DEROctetString(x509Cert.getEncoding());
            publicInfoVector.add(pubDEROctetString);
            DERSequence publicInfo = new DERSequence(publicInfoVector);
            ASN1EncodableVector privateInfoVector = new ASN1EncodableVector();
            privateInfoVector.add(PKCSObjectIdentifiers.sm2Data);
            privateInfoVector.add(PKCSObjectIdentifiers.SM4_CBC);
            DEROctetString prvDEROctetString = new DEROctetString(encryptedData);
            privateInfoVector.add(prvDEROctetString);
            DERSequence privateInfo = new DERSequence(privateInfoVector);
            return new PKCS12_SM2(publicInfo, privateInfo);
        }
        catch (Exception e) {
            throw new PKIException("SM2File Generated failure", e);
        }
    }

    public static String generateSM2File(X509Cert x509Cert, PrivateKey privateKey, String password, String fileName) throws PKIException {
        if (fileName == null) {
            throw new PKIException("SM2File fileName should not be null");
        }
        byte[] encoding = PKCS12_SM2.generateSM2Data(x509Cert, privateKey, password);
        try {
            FileHelper.write(fileName, encoding);
        }
        catch (IOException e) {
            throw new PKIException("Writing SM2File failure with IOException", e);
        }
        return fileName;
    }

    public static byte[] generateSM2Data(X509Cert x509Cert, PrivateKey privateKey, String password) throws PKIException {
        byte[] encoding = PKCS12_SM2.CombineSM2Data(x509Cert, privateKey, password);
        if (SM2ContextConfig.getBase64State()) {
            encoding = Base64.encode(encoding);
        }
        return encoding;
    }

    public static byte[] CombineSM2Data(X509Cert x509Cert, PrivateKey privateKey, String password) throws PKIException {
        byte[] encoding;
        PKCS12_SM2 p12_SM2 = PKCS12_SM2.generateSM2(x509Cert, privateKey, password);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream out = new DEROutputStream(baos);
            out.writeObject(p12_SM2);
            encoding = baos.toByteArray();
        }
        catch (IOException e) {
            throw new PKIException("Encoding SM2File failure with IOException", e);
        }
        return encoding;
    }
}

