/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.tx.personalinfo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import cpcn.dsp.institution.api.tx.TxBaseResponse;
import cpcn.dsp.institution.api.vo.AdmPunishment;
import cpcn.dsp.institution.api.vo.BusinessLicenseBad;
import cpcn.dsp.institution.api.vo.CourtBreakFaith;
import cpcn.dsp.institution.api.vo.CourtExecutor;
import cpcn.dsp.institution.api.vo.EvadeTax;
import cpcn.dsp.institution.api.vo.ShareFreeze;
import java.util.ArrayList;
import java.util.List;

public class Tx2212Response
extends TxBaseResponse {
    private String institutionID;
    private String txSN;
    private String traceNo;
    private String responseCode;
    private String responseMessage;
    private String blackLevel;
    private String blackReason;
    private List<CourtBreakFaith> courtBreakFaithList;
    private List<EvadeTax> evadeTaxList;
    private List<ShareFreeze> shareFreezeList;
    private List<BusinessLicenseBad> businessLicenseBadList;
    private List<CourtExecutor> courtExecutorList;
    private List<AdmPunishment> admPunishmentList;

    public Tx2212Response(String responseMessage, String responseSignature) throws Exception {
        super(responseMessage, responseSignature);
    }

    public Tx2212Response(String responseMessage, String responseSignature, String responseDgtlEnvlp, String responseSignSN, String responseEncryptSN) throws Exception {
        super(responseMessage, responseSignature, responseDgtlEnvlp, responseSignSN, responseEncryptSN);
    }

    @Override
    protected void process(String document) throws Exception {
        if ("2000".equals(this.code)) {
            JSONObject jsonObject = JSONObject.parseObject((String)document);
            this.institutionID = jsonObject.getString("InstitutionID");
            this.txSN = jsonObject.getString("TxSN");
            this.traceNo = jsonObject.getString("TraceNo");
            this.responseCode = jsonObject.getString("ResponseCode");
            this.responseMessage = jsonObject.getString("ResponseMessage");
            this.blackLevel = jsonObject.getString("BlackLevel");
            this.blackReason = jsonObject.getString("BlackReason");
            this.courtBreakFaithList = this.processCourtBreakFaithList(jsonObject);
            this.evadeTaxList = this.processEvadeTaxList(jsonObject);
            this.shareFreezeList = this.processShareFreezeList(jsonObject);
            this.businessLicenseBadList = this.processBusinessLicenseBadList(jsonObject);
            this.courtExecutorList = this.processCourtExecutorList(jsonObject);
            this.admPunishmentList = this.processAdmPunishmentList(jsonObject);
        }
    }

    private List<AdmPunishment> processAdmPunishmentList(JSONObject jsonObject) {
        JSONArray jsonArray = jsonObject.getJSONArray("AdmPunishmentList");
        ArrayList<AdmPunishment> list = new ArrayList<AdmPunishment>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                AdmPunishment admPunishment = new AdmPunishment();
                JSONObject jsonObj = (JSONObject)jsonArray.get(i);
                admPunishment.setPunishNo(jsonObj.getString("PunishNo"));
                admPunishment.setPunishName(jsonObj.getString("PunishName"));
                admPunishment.setPunishFact(jsonObj.getString("PunishFact"));
                admPunishment.setPunishResult(jsonObj.getString("PunishResult"));
                admPunishment.setPunishOrg(jsonObj.getString("PunishOrg"));
                admPunishment.setUpdateTime(jsonObj.getString("UpdateTime"));
                list.add(admPunishment);
            }
        }
        return list;
    }

    private List<CourtExecutor> processCourtExecutorList(JSONObject jsonObject) {
        JSONArray jsonArray = jsonObject.getJSONArray("CourtExecutorList");
        ArrayList<CourtExecutor> list = new ArrayList<CourtExecutor>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                CourtExecutor courtExecutor = new CourtExecutor();
                JSONObject jsonObj = (JSONObject)jsonArray.get(i);
                courtExecutor.setRegisterDate(jsonObj.getString("RegisterDate"));
                courtExecutor.setCaseNo(jsonObj.getString("CaseNo"));
                courtExecutor.setCourt(jsonObj.getString("Court"));
                courtExecutor.setExecuteMoney(jsonObj.getString("ExecuteMoney"));
                list.add(courtExecutor);
            }
        }
        return list;
    }

    private List<BusinessLicenseBad> processBusinessLicenseBadList(JSONObject jsonObject) {
        JSONArray jsonArray = jsonObject.getJSONArray("BusinessLicenseBadList");
        ArrayList<BusinessLicenseBad> list = new ArrayList<BusinessLicenseBad>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                BusinessLicenseBad businessLicenseBad = new BusinessLicenseBad();
                JSONObject jsonObj = (JSONObject)jsonArray.get(i);
                businessLicenseBad.setPublishmentNo(jsonObj.getString("PublishmentNo"));
                businessLicenseBad.setMajorFact(jsonObj.getString("MajorFact"));
                businessLicenseBad.setHandleOrgName(jsonObj.getString("HandleOrgName"));
                businessLicenseBad.setPublishDate(jsonObj.getString("PublishDate"));
                businessLicenseBad.setPunishmentContent(jsonObj.getString("PunishmentContent"));
                list.add(businessLicenseBad);
            }
        }
        return list;
    }

    private List<ShareFreeze> processShareFreezeList(JSONObject jsonObject) {
        JSONArray jsonArray = jsonObject.getJSONArray("ShareFreezeList");
        ArrayList<ShareFreeze> list = new ArrayList<ShareFreeze>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                ShareFreeze shareFreeze = new ShareFreeze();
                JSONObject jsonObj = (JSONObject)jsonArray.get(i);
                shareFreeze.setExecuteCourt(jsonObj.getString("ExecuteCourt"));
                shareFreeze.setPublishmentNo(jsonObj.getString("PublishmentNo"));
                shareFreeze.setFreezeAmount(jsonObj.getString("FreezeAmount"));
                shareFreeze.setPublishDate(jsonObj.getString("PublishDate"));
                shareFreeze.setCorporationName(jsonObj.getString("CorporationName"));
                list.add(shareFreeze);
            }
        }
        return list;
    }

    private List<EvadeTax> processEvadeTaxList(JSONObject jsonObject) {
        JSONArray jsonArray = jsonObject.getJSONArray("EvadeTaxList");
        ArrayList<EvadeTax> list = new ArrayList<EvadeTax>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                EvadeTax evadeTax = new EvadeTax();
                JSONObject jsonObj = (JSONObject)jsonArray.get(i);
                evadeTax.setTaxpayerName(jsonObj.getString("TaxpayerName"));
                evadeTax.setTaxpayerID(jsonObj.getString("TaxpayerID"));
                evadeTax.setInfoSource(jsonObj.getString("InfoSource"));
                evadeTax.setMajorFact(jsonObj.getString("MajorFact"));
                list.add(evadeTax);
            }
        }
        return list;
    }

    private List<CourtBreakFaith> processCourtBreakFaithList(JSONObject jsonObject) {
        JSONArray jsonArray = jsonObject.getJSONArray("CourtBreakFaithList");
        ArrayList<CourtBreakFaith> list = new ArrayList<CourtBreakFaith>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                CourtBreakFaith courtBreakFaith = new CourtBreakFaith();
                JSONObject jsonObj = (JSONObject)jsonArray.get(i);
                courtBreakFaith.setDuty(jsonObj.getString("Duty"));
                courtBreakFaith.setPerformance(jsonObj.getString("Performance"));
                courtBreakFaith.setPublishDate(jsonObj.getString("PublishDate"));
                courtBreakFaith.setProvince(jsonObj.getString("Province"));
                courtBreakFaith.setExecuteCourt(jsonObj.getString("ExecuteCourt"));
                courtBreakFaith.setCaseNo(jsonObj.getString("CaseNo"));
                courtBreakFaith.setDisruptTypeName(jsonObj.getString("DisruptTypeName"));
                list.add(courtBreakFaith);
            }
        }
        return list;
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getTxSN() {
        return this.txSN;
    }

    public String getTraceNo() {
        return this.traceNo;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getBlackLevel() {
        return this.blackLevel;
    }

    public String getBlackReason() {
        return this.blackReason;
    }

    public List<CourtBreakFaith> getCourtBreakFaithList() {
        return this.courtBreakFaithList;
    }

    public List<EvadeTax> getEvadeTaxList() {
        return this.evadeTaxList;
    }

    public List<ShareFreeze> getShareFreezeList() {
        return this.shareFreezeList;
    }

    public List<BusinessLicenseBad> getBusinessLicenseBadList() {
        return this.businessLicenseBadList;
    }

    public List<CourtExecutor> getCourtExecutorList() {
        return this.courtExecutorList;
    }

    public List<AdmPunishment> getAdmPunishmentList() {
        return this.admPunishmentList;
    }
}

