/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.security;

import cpcn.dsp.institution.api.system.DSPInstitutionEnvironment;
import cpcn.dsp.institution.api.util.Base64;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class EncryptAndDecrypt {
    private static EncryptAndDecrypt encryptAndDecrypt;
    private static final String algorithm = "SHA1withRSA";
    public static final String aes_algorithm = "AES/ECB/PKCS7Padding";
    public static final String rsa_algorithm = "RSA/ECB/PKCS1Padding";
    private PrivateKey privateKey;
    private X509Certificate x509Certificate;
    public String requestSignSN;
    private PublicKey publicKey;
    private X509Certificate x509Certificate2;
    public String requestEncryptSN;

    private EncryptAndDecrypt() {
    }

    public static EncryptAndDecrypt getEncryptAndDecrypt() {
        if (encryptAndDecrypt == null) {
            throw new RuntimeException("\u8bc1\u4e66\u672a\u521d\u59cb\u5316");
        }
        return encryptAndDecrypt;
    }

    private EncryptAndDecrypt(String myKeystoreFilepath, String myKeystorePassword, String certificateFilepath) throws Exception {
        FileInputStream fis = new FileInputStream(myKeystoreFilepath);
        this.initPfxSingner(fis, myKeystorePassword);
        fis = new FileInputStream(certificateFilepath);
        this.initPublicKey(fis);
        Security.addProvider((Provider)new BouncyCastleProvider());
        fis.close();
        DSPInstitutionEnvironment.initialize(myKeystoreFilepath, myKeystorePassword, certificateFilepath, "20");
    }

    private EncryptAndDecrypt(InputStream myKeystoreStream, String myKeystorePassword, InputStream certificateStream) throws Exception {
        if (myKeystoreStream == null || certificateStream == null) {
            throw new RuntimeException("\u52a0\u8f7d\u5931\u8d25\uff1astream is null ");
        }
        this.initPfxSingner(myKeystoreStream, myKeystorePassword);
        this.initPublicKey(certificateStream);
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static synchronized void init(String myKeystoreFilepath, String myKeystorePassword, String certificateFilepath) throws Exception {
        if (encryptAndDecrypt == null) {
            encryptAndDecrypt = new EncryptAndDecrypt(myKeystoreFilepath, myKeystorePassword, certificateFilepath);
        }
    }

    public static synchronized void initByStream(InputStream myKeystoreStream, String myKeystorePassword, InputStream certificateStream) throws Exception {
        if (encryptAndDecrypt == null) {
            encryptAndDecrypt = new EncryptAndDecrypt(myKeystoreStream, myKeystorePassword, certificateStream);
        }
    }

    private void initPfxSingner(InputStream myKeystoreStream, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(myKeystoreStream, password.toCharArray());
        Enumeration<String> aliases = keyStore.aliases();
        String alias = aliases.nextElement();
        this.privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        this.x509Certificate = (X509Certificate)keyStore.getCertificate(alias);
        this.requestSignSN = String.valueOf(this.x509Certificate.getSerialNumber());
    }

    private void initPublicKey(InputStream certificateStream) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        this.x509Certificate2 = (X509Certificate)cf.generateCertificate(certificateStream);
        this.publicKey = this.x509Certificate2.getPublicKey();
        this.requestEncryptSN = String.valueOf(this.x509Certificate2.getSerialNumber());
    }

    public static String randomHexString(int len) {
        StringBuffer result = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < len; ++i) {
            result.append(Integer.toHexString(random.nextInt(16)));
        }
        return result.toString().toUpperCase();
    }

    public String encryptByRSA(byte[] plainData) throws Exception {
        Cipher cipher = Cipher.getInstance(rsa_algorithm);
        cipher.init(1, this.publicKey);
        byte[] output = cipher.doFinal(plainData);
        return new String(Base64.encode(output));
    }

    public static String encode(String str, String key) throws Exception {
        Cipher cipher = Cipher.getInstance(aes_algorithm, "BC");
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
        cipher.init(1, keySpec);
        byte[] result = cipher.doFinal(str.getBytes("UTF-8"));
        return new String(Base64.encode(result));
    }

    public byte[] sign(byte[] bytes) throws Exception {
        Signature signature = Signature.getInstance(algorithm);
        signature.initSign(this.privateKey);
        signature.update(bytes);
        return signature.sign();
    }

    public String getDecryptKeyByteByRSA(String respDgtlEnvlp) throws Exception {
        Cipher cipher = Cipher.getInstance(rsa_algorithm);
        cipher.init(2, this.privateKey);
        byte[] output = cipher.doFinal(Base64.decode(respDgtlEnvlp));
        return EncryptAndDecrypt.bytes2hex(output);
    }

    public static String decodeByAES(String key, String cipherText) throws Exception {
        byte[] resByte = Base64.decode(cipherText);
        Cipher cipher = Cipher.getInstance(aes_algorithm, "BC");
        SecretKeySpec keySpec = new SecretKeySpec(EncryptAndDecrypt.hex2bytes(key), "AES");
        cipher.init(2, keySpec);
        byte[] decoded = cipher.doFinal(resByte);
        return new String(decoded, "UTF-8");
    }

    public Boolean verify(byte[] msg, String sign) throws Exception {
        byte[] signature = EncryptAndDecrypt.hex2bytes(sign);
        Signature sig = Signature.getInstance(algorithm);
        sig.initVerify(this.publicKey);
        sig.update(msg);
        return sig.verify(signature);
    }

    public static String bytes2hex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        String b = "";
        if (null == bytes) {
            return null;
        }
        for (int i = 0; i < bytes.length; ++i) {
            b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() == 1) {
                result.append("0");
            }
            result.append(b);
        }
        return result.toString().toUpperCase();
    }

    public static byte[] hex2bytes(String hexStringParam) {
        String hexString = hexStringParam;
        hexString = hexString.toUpperCase();
        char[] chars = hexString.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int index = 0;
        for (int i = 0; i < chars.length; i += 2) {
            byte newByte = 0;
            newByte = (byte)(newByte | EncryptAndDecrypt.char2byte(chars[i]));
            newByte = (byte)(newByte << 4);
            bytes[index] = newByte = (byte)(newByte | EncryptAndDecrypt.char2byte(chars[i + 1]));
            ++index;
        }
        return bytes;
    }

    private static byte char2byte(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return Byte.parseByte(String.valueOf(ch), 16);
            }
        }
        return 0;
    }

    public static String createLinkStringByGet(Map<String, String> params) throws UnsupportedEncodingException {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            value = URLEncoder.encode(value, "UTF-8");
            prestr = i == keys.size() - 1 ? prestr + key + "=" + value : prestr + key + "=" + value + "&";
        }
        return prestr;
    }
}

