/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.net;

import cpcn.dsp.institution.api.io.IoUtil;
import cpcn.dsp.institution.api.net.HttpData;
import cpcn.dsp.institution.api.net.SecurityContext;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.logging.Logger;

public class HttpConnectionBySocket {
    private static Logger logger = Logger.getLogger("system");
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    private String outputCharset = "UTF-8";
    private String inputCharset = "UTF-8";
    private String spec;

    public HttpConnectionBySocket(String url) {
        this.spec = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String send(HttpData httpData) throws Exception {
        String response;
        URL url = new URL(this.spec);
        String host = url.getHost();
        int port = url.getPort();
        String protocol = url.getProtocol();
        if (port == -1) {
            if ("https".equals(protocol)) {
                port = 443;
            } else if ("http".equals(protocol)) {
                port = 80;
            } else {
                throw new Exception("Protocol error, protocol must be https or http.");
            }
        }
        String content = httpData.getData();
        StringBuffer sb = new StringBuffer();
        sb.append("POST ").append(this.spec).append(" HTTP/1.1\r\n");
        sb.append("Content-Type: text/html; charset=UTF-8\r\n");
        sb.append("Content-Length: ").append(content.length()).append("\r\n");
        sb.append("\r\n");
        sb.append(content);
        sb.append("\r\n");
        String request = sb.toString();
        logger.info(request);
        Socket socket = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        if ("https".equals(protocol)) {
            try {
                socket = SecurityContext.sslSocketFactory.createSocket(host, port);
                outputStream = socket.getOutputStream();
                outputStream.write(request.getBytes(this.outputCharset));
                outputStream.flush();
                inputStream = socket.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                for (int i = 0; i < 10; ++i) {
                    String line = bufferedReader.readLine();
                    logger.info(line);
                    if (!"".equals(line)) continue;
                    logger.info("k");
                    break;
                }
                byte[] bytes = new byte[525];
                StringBuilder responseBuilder = new StringBuilder();
                while (inputStream.read(bytes) > 0) {
                    responseBuilder.append(new String(bytes));
                }
                response = responseBuilder.toString();
                logger.info(response);
            }
            finally {
                if (null != socket) {
                    socket.close();
                }
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null != outputStream) {
                    outputStream.close();
                }
            }
        }
        try {
            socket = new Socket(host, port);
            outputStream = socket.getOutputStream();
            outputStream.write(request.getBytes(this.outputCharset));
            outputStream.flush();
            socket.shutdownOutput();
            inputStream = socket.getInputStream();
            byte[] bytes = IoUtil.read(inputStream, 1024);
            response = new String(bytes, this.inputCharset).trim();
        }
        finally {
            if (null != socket) {
                socket.close();
            }
            if (null != inputStream) {
                inputStream.close();
            }
            if (null != outputStream) {
                outputStream.close();
            }
        }
        return response;
    }

    public void setOutputCharset(String outputCharset) {
        this.outputCharset = outputCharset;
    }

    public void setInputCharset(String inputCharset) {
        this.inputCharset = inputCharset;
    }
}

