/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

final class PreferredCipherSuiteSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory delegate;
    private final String[] defaultCipherSuites;
    private final String[] supportedCipherSuites;

    public PreferredCipherSuiteSSLSocketFactory(SSLSocketFactory delegate) {
        this.delegate = delegate;
        String sipherSuite = "TLS_SM2PKEA_SM2DSA_WITH_SM4_CBC_SM3";
        String[] cipherSuites = delegate.getDefaultCipherSuites();
        ArrayList<String> suitesList = new ArrayList<String>(Arrays.asList(cipherSuites));
        suitesList.remove("TLS_SM2PKEA_SM2DSA_WITH_SM4_CBC_SM3");
        suitesList.add(0, "TLS_SM2PKEA_SM2DSA_WITH_SM4_CBC_SM3");
        cipherSuites = suitesList.toArray(new String[suitesList.size()]);
        this.defaultCipherSuites = (String[])cipherSuites.clone();
        this.supportedCipherSuites = (String[])cipherSuites.clone();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.defaultCipherSuites;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.supportedCipherSuites;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.delegate.createSocket(host, port);
        ((SSLSocket)socket).setEnabledCipherSuites(this.defaultCipherSuites);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.delegate.createSocket(host, port);
        ((SSLSocket)socket).setEnabledCipherSuites(this.defaultCipherSuites);
        return socket;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Socket socket = this.delegate.createSocket(s, host, port, autoClose);
        ((SSLSocket)socket).setEnabledCipherSuites(this.defaultCipherSuites);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.delegate.createSocket(host, port, localHost, localPort);
        ((SSLSocket)socket).setEnabledCipherSuites(this.defaultCipherSuites);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.delegate.createSocket(address, port, localAddress, localPort);
        ((SSLSocket)socket).setEnabledCipherSuites(this.defaultCipherSuites);
        return socket;
    }
}

