/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.util;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public final class ClientDecryptionUtil {
    private static Logger logger = Logger.getLogger((String)"system");
    private static final byte[] KEY_DATA = new byte[]{-28, -72, -83, -23, -121, -111, -24, -98, -115, -28, -65, -95, -28, -65, -95, -24, -98, -115, -27, -92, -87, -28, -72, -117};
    private static final byte[] IV_DATA = new byte[]{67, 80, 67, 78, 33, 64, 35, 36};
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String CIPHER_INSTANCE = "DESede/CBC/PKCS5Padding";

    private ClientDecryptionUtil() {
    }

    public static String decrypt(String cipherText) {
        return ClientDecryptionUtil.decrypt3DES(cipherText);
    }

    public static String encrypt(String plainText) {
        return ClientDecryptionUtil.encrypt3DES(plainText);
    }

    public static String decrypt3DES(String cipherText) {
        String plainText;
        block3: {
            plainText = null;
            try {
                byte[] decryptStr;
                if (null != cipherText && (decryptStr = ClientDecryptionUtil.des3CBCDecrypt(IV_DATA, KEY_DATA, ClientDecryptionUtil.hex2bytes(cipherText))) != null) {
                    plainText = new String(decryptStr);
                }
            }
            catch (Exception e) {
                if (null == logger) break block3;
                logger.error((Object)"3DES\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
            }
        }
        return plainText;
    }

    private static byte[] des3CBCDecrypt(byte[] ivData, byte[] keyData, byte[] cipherText) {
        byte[] plainText;
        block2: {
            SecretKeySpec key3Des = new SecretKeySpec(keyData, "DESede");
            IvParameterSpec ivSpec = new IvParameterSpec(ivData);
            plainText = null;
            try {
                Cipher cipher = Cipher.getInstance(CIPHER_INSTANCE);
                cipher.init(2, (Key)key3Des, ivSpec);
                plainText = cipher.doFinal(cipherText);
            }
            catch (Exception e) {
                if (null == logger) break block2;
                logger.error((Object)"DecryptCipher Exception:- ", (Throwable)e);
            }
        }
        return plainText;
    }

    public static String encrypt3DES(String plainText) {
        String cipherText;
        block3: {
            cipherText = null;
            try {
                if (null != plainText) {
                    cipherText = ClientDecryptionUtil.bytes2hex(ClientDecryptionUtil.des3CBCEncrypt(IV_DATA, KEY_DATA, plainText.getBytes(DEFAULT_CHARSET)));
                }
            }
            catch (Exception e) {
                if (null == logger) break block3;
                logger.error((Object)"3DES\u52a0\u5bc6\u5f02\u5e38 ", (Throwable)e);
            }
        }
        return cipherText;
    }

    private static byte[] des3CBCEncrypt(byte[] ivData, byte[] keyData, byte[] plainText) {
        byte[] cipherText;
        block2: {
            SecretKeySpec key3Des = new SecretKeySpec(keyData, "DESede");
            IvParameterSpec ivSpec = new IvParameterSpec(ivData);
            cipherText = null;
            try {
                Cipher cipher = Cipher.getInstance(CIPHER_INSTANCE);
                cipher.init(1, (Key)key3Des, ivSpec);
                cipherText = cipher.doFinal(plainText);
            }
            catch (Exception e) {
                if (null == logger) break block2;
                logger.error((Object)"3DES\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
            }
        }
        return cipherText;
    }

    public static String encryptAES(String plainText, String key) throws UnsupportedEncodingException {
        String cipherText;
        block3: {
            cipherText = null;
            byte[] keyData = key.getBytes(DEFAULT_CHARSET);
            try {
                if (null != plainText) {
                    cipherText = ClientDecryptionUtil.bytes2hex(ClientDecryptionUtil.aesEncrypt(keyData, plainText.getBytes(DEFAULT_CHARSET)));
                }
            }
            catch (Exception e) {
                if (null == logger) break block3;
                logger.error((Object)"AES\u52a0\u5bc6\u5f02\u5e38 ", (Throwable)e);
            }
        }
        return cipherText;
    }

    private static byte[] aesEncrypt(byte[] keyData, byte[] plainData) {
        SecretKeySpec keyAES = new SecretKeySpec(keyData, "AES");
        byte[] cipherData = null;
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, keyAES);
            cipherData = cipher.doFinal(plainData);
        }
        catch (Exception e) {
            logger.error((Object)"AES\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
        }
        return cipherData;
    }

    public static String decryptAES(String cipherText, String key) throws UnsupportedEncodingException {
        String plainText;
        block3: {
            plainText = null;
            byte[] keyData = key.getBytes(DEFAULT_CHARSET);
            try {
                byte[] plainData;
                if (null != cipherText && (plainData = ClientDecryptionUtil.aesDecrypt(keyData, ClientDecryptionUtil.hex2bytes(cipherText))) != null) {
                    plainText = new String(plainData, DEFAULT_CHARSET);
                }
            }
            catch (Exception e) {
                if (null == logger) break block3;
                logger.error((Object)"AES\u89e3\u5bc6\u5f02\u5e38 ", (Throwable)e);
            }
        }
        return plainText;
    }

    private static byte[] aesDecrypt(byte[] keyData, byte[] cipherData) {
        SecretKeySpec keyAES = new SecretKeySpec(keyData, "AES");
        byte[] plainData = null;
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, keyAES);
            plainData = cipher.doFinal(cipherData);
        }
        catch (Exception e) {
            logger.error((Object)"AES\u89e3\u5bc6\u5f02\u5e38 ", (Throwable)e);
        }
        return plainData;
    }

    private static byte[] hex2bytes(String hexStringParam) {
        String hexString = hexStringParam;
        String hexStringUpper = hexString.toUpperCase();
        char[] chars = hexStringUpper.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int index = 0;
        for (int i = 0; i < chars.length; i += 2) {
            byte newByte = 0;
            newByte = (byte)(newByte | ClientDecryptionUtil.char2byte(chars[i]));
            newByte = (byte)(newByte << 4);
            bytes[index] = newByte = (byte)(newByte | ClientDecryptionUtil.char2byte(chars[i + 1]));
            ++index;
        }
        return bytes;
    }

    private static byte char2byte(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return Byte.parseByte(String.valueOf(ch), 16);
            }
        }
        return 0;
    }

    private static String bytes2hex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        String b = "";
        if (null == bytes) {
            return null;
        }
        for (int i = 0; i < bytes.length; ++i) {
            b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() == 1) {
                result.append("0");
            }
            result.append(b);
        }
        return result.toString().toUpperCase();
    }
}

