/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.tx.personalinfo;

import com.alibaba.fastjson.JSONObject;
import cpcn.dsp.institution.api.tx.TxBaseResponse;
import cpcn.dsp.institution.api.util.JSONUtil;
import cpcn.dsp.institution.api.vo.AdministrativePunishInfo;
import cpcn.dsp.institution.api.vo.BreakFaithExecutorInfo;
import cpcn.dsp.institution.api.vo.FinalCaseInfo;
import cpcn.dsp.institution.api.vo.InvestmentEntInfo;
import cpcn.dsp.institution.api.vo.JudicialExecutorInfo;
import cpcn.dsp.institution.api.vo.OrgExecutiveInfo;
import cpcn.dsp.institution.api.vo.OrgLrInfo;
import java.util.List;

public class Tx2210Response
extends TxBaseResponse {
    private String institutionID;
    private String txSN;
    private String traceNo;
    private String responseCode;
    private String responseMessage;
    private List<OrgLrInfo> orgLrInfoList;
    private List<InvestmentEntInfo> investmentEntInfoList;
    private List<OrgExecutiveInfo> orgExecutiveInfoList;
    private List<BreakFaithExecutorInfo> breakFaithExecutorInfoList;
    private List<JudicialExecutorInfo> judicialExecutorInfoList;
    private List<AdministrativePunishInfo> administrativePunishInfoList;
    private List<FinalCaseInfo> finalCaseInfoList;

    public Tx2210Response(String responseMessage, String responseSignature) throws Exception {
        super(responseMessage, responseSignature);
    }

    public Tx2210Response(String responseMessage, String responseSignature, String responseDgtlEnvlp, String responseSignSN, String responseEncryptSN) throws Exception {
        super(responseMessage, responseSignature, responseDgtlEnvlp, responseSignSN, responseEncryptSN);
    }

    @Override
    protected void process(String document) throws Exception {
        if ("2000".equals(this.code)) {
            JSONObject jsonObject = JSONObject.parseObject((String)document);
            this.institutionID = jsonObject.getString("InstitutionID");
            this.txSN = jsonObject.getString("TxSN");
            this.traceNo = jsonObject.getString("TraceNo");
            this.responseCode = jsonObject.getString("ResponseCode");
            this.responseMessage = jsonObject.getString("ResponseMessage");
            this.orgLrInfoList = this.processOrgLrInfoList(jsonObject);
            this.investmentEntInfoList = this.processInvestmentEntInfoList(jsonObject);
            this.orgExecutiveInfoList = this.processOrgExecutiveInfoList(jsonObject);
            this.breakFaithExecutorInfoList = this.processBreakFaithExecutorInfoList(jsonObject);
            this.judicialExecutorInfoList = this.processJudicialExecutorInfoList(jsonObject);
            this.administrativePunishInfoList = this.processAdministrativePunishInfoList(jsonObject);
            this.finalCaseInfoList = this.processFinalCaseInfoList(jsonObject);
        }
    }

    private List<FinalCaseInfo> processFinalCaseInfoList(JSONObject jsonObject) {
        return JSONUtil.toList(jsonObject.getString("FinalCaseInfoList"), FinalCaseInfo.class);
    }

    private List<AdministrativePunishInfo> processAdministrativePunishInfoList(JSONObject jsonObject) {
        return JSONUtil.toList(jsonObject.getString("AdministrativePunishInfoList"), AdministrativePunishInfo.class);
    }

    private List<JudicialExecutorInfo> processJudicialExecutorInfoList(JSONObject jsonObject) {
        return JSONUtil.toList(jsonObject.getString("JudicialExecutorInfoList"), JudicialExecutorInfo.class);
    }

    private List<BreakFaithExecutorInfo> processBreakFaithExecutorInfoList(JSONObject jsonObject) {
        return JSONUtil.toList(jsonObject.getString("BreakFaithExecutorInfoList"), BreakFaithExecutorInfo.class);
    }

    private List<OrgExecutiveInfo> processOrgExecutiveInfoList(JSONObject jsonObject) {
        return JSONUtil.toList(jsonObject.getString("OrgExecutiveInfoList"), OrgExecutiveInfo.class);
    }

    private List<InvestmentEntInfo> processInvestmentEntInfoList(JSONObject jsonObject) {
        return JSONUtil.toList(jsonObject.getString("InvestmentEntInfoList"), InvestmentEntInfo.class);
    }

    private List<OrgLrInfo> processOrgLrInfoList(JSONObject jsonObject) {
        return JSONUtil.toList(jsonObject.getString("OrgLrInfoList"), OrgLrInfo.class);
    }

    private <T> List<T> getList(String json, Class<T> beanClass) {
        return JSONUtil.toList(json, beanClass);
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public void setInstitutionID(String institutionID) {
        this.institutionID = institutionID;
    }

    public String getTxSN() {
        return this.txSN;
    }

    public void setTxSN(String txSN) {
        this.txSN = txSN;
    }

    public String getTraceNo() {
        return this.traceNo;
    }

    public void setTraceNo(String traceNo) {
        this.traceNo = traceNo;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public List<OrgLrInfo> getOrgLrInfoList() {
        return this.orgLrInfoList;
    }

    public void setOrgLrInfoList(List<OrgLrInfo> orgLrInfoList) {
        this.orgLrInfoList = orgLrInfoList;
    }

    public List<OrgExecutiveInfo> getOrgExecutiveInfoList() {
        return this.orgExecutiveInfoList;
    }

    public void setOrgExecutiveInfoList(List<OrgExecutiveInfo> orgExecutiveInfoList) {
        this.orgExecutiveInfoList = orgExecutiveInfoList;
    }

    public List<BreakFaithExecutorInfo> getBreakFaithExecutorInfoList() {
        return this.breakFaithExecutorInfoList;
    }

    public void setBreakFaithExecutorInfoList(List<BreakFaithExecutorInfo> breakFaithExecutorInfoList) {
        this.breakFaithExecutorInfoList = breakFaithExecutorInfoList;
    }

    public List<JudicialExecutorInfo> getJudicialExecutorInfoList() {
        return this.judicialExecutorInfoList;
    }

    public void setJudicialExecutorInfoList(List<JudicialExecutorInfo> judicialExecutorInfoList) {
        this.judicialExecutorInfoList = judicialExecutorInfoList;
    }

    public List<InvestmentEntInfo> getInvestmentEntInfoList() {
        return this.investmentEntInfoList;
    }

    public void setInvestmentEntInfoList(List<InvestmentEntInfo> investmentEntInfoList) {
        this.investmentEntInfoList = investmentEntInfoList;
    }

    public List<AdministrativePunishInfo> getAdministrativePunishInfoList() {
        return this.administrativePunishInfoList;
    }

    public void setAdministrativePunishInfoList(List<AdministrativePunishInfo> administrativePunishInfoList) {
        this.administrativePunishInfoList = administrativePunishInfoList;
    }

    public List<FinalCaseInfo> getFinalCaseInfoList() {
        return this.finalCaseInfoList;
    }

    public void setFinalCaseInfoList(List<FinalCaseInfo> finalCaseInfoList) {
        this.finalCaseInfoList = finalCaseInfoList;
    }
}

