/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.net;

import cpcn.dsp.institution.api.io.IoUtil;
import cpcn.dsp.institution.api.net.HttpData;
import cpcn.dsp.institution.api.net.HttpsConnection;
import cpcn.dsp.institution.api.net.IgnoreHostnameVerifier;
import cpcn.dsp.institution.api.net.NameValuePair;
import cpcn.dsp.institution.api.net.SecurityContext;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;

public class DefaultHttpsConnection
extends HttpsConnection {
    private int connectTimeoutLimit = 50000;
    private int readTimeoutLimit = 50000;
    private HttpsURLConnection httpsURLConnection;

    public DefaultHttpsConnection(String spec) throws IOException {
        URL url = new URL(spec);
        this.httpsURLConnection = (HttpsURLConnection)url.openConnection();
    }

    @Override
    public String send(List<NameValuePair> list) throws IOException {
        HttpData httpData = new HttpData(list, this.outputCharset);
        String request = httpData.getData();
        return this.send(request);
    }

    @Override
    public String send(String request) throws IOException {
        if (!this.useDefaultSSLSocketFactory) {
            this.httpsURLConnection.setSSLSocketFactory(SecurityContext.sslSocketFactory);
        }
        if (this.ignoreHostname) {
            this.httpsURLConnection.setHostnameVerifier(new IgnoreHostnameVerifier());
        }
        this.httpsURLConnection.setRequestProperty("Content-Type", this.contentType);
        this.httpsURLConnection.setDoOutput(true);
        this.httpsURLConnection.setRequestMethod(this.method);
        this.httpsURLConnection.setConnectTimeout(this.connectTimeoutLimit);
        this.httpsURLConnection.setReadTimeout(this.readTimeoutLimit);
        OutputStream outputStream = this.httpsURLConnection.getOutputStream();
        outputStream.write(request.getBytes(this.outputCharset));
        outputStream.flush();
        outputStream.close();
        InputStream inputStream = this.httpsURLConnection.getInputStream();
        byte[] bytes = IoUtil.read(inputStream, 1024);
        inputStream.close();
        return new String(bytes, this.inputCharset).trim();
    }

    @Override
    public String sendWithAttachment(Map<String, String> paramMap, Map<String, String> fileMap) throws IOException {
        if (!this.useDefaultSSLSocketFactory) {
            this.httpsURLConnection.setSSLSocketFactory(SecurityContext.sslSocketFactory);
        }
        if (this.ignoreHostname) {
            this.httpsURLConnection.setHostnameVerifier(new IgnoreHostnameVerifier());
        }
        int MAX_BUFFER_SIZE = 16384;
        String BOUNDARY = UUID.randomUUID().toString();
        String PREFIX = "--";
        String LINEND = "\r\n";
        String MULTIPART_FROM_DATA = "multipart/form-data";
        String CHARSET = "UTF-8";
        this.httpsURLConnection.setReadTimeout(this.readTimeoutLimit);
        this.httpsURLConnection.setConnectTimeout(this.connectTimeoutLimit);
        this.httpsURLConnection.setDoInput(true);
        this.httpsURLConnection.setDoOutput(true);
        this.httpsURLConnection.setUseCaches(false);
        this.httpsURLConnection.setRequestMethod("POST");
        this.httpsURLConnection.setRequestProperty("connection", "keep-alive");
        this.httpsURLConnection.setRequestProperty("Charsert", this.inputCharset);
        this.httpsURLConnection.setRequestProperty("Content-Type", MULTIPART_FROM_DATA + ";boundary=" + BOUNDARY);
        this.httpsURLConnection.setChunkedStreamingMode(16384);
        this.httpsURLConnection.setRequestProperty("Transfer-Encoding", "chunked");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            sb.append(PREFIX);
            sb.append(BOUNDARY);
            sb.append(LINEND);
            sb.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"" + LINEND);
            sb.append("Content-Type: text/plain; charset=" + CHARSET + LINEND);
            sb.append("Content-Transfer-Encoding: 8bit" + LINEND);
            sb.append(LINEND);
            sb.append(entry.getValue());
            sb.append(LINEND);
        }
        DataOutputStream outStream = new DataOutputStream(this.httpsURLConnection.getOutputStream());
        outStream.write(sb.toString().getBytes(this.inputCharset));
        if (fileMap != null) {
            for (Map.Entry<String, String> entry : fileMap.entrySet()) {
                StringBuilder sb1 = new StringBuilder();
                sb1.append(PREFIX);
                sb1.append(BOUNDARY);
                sb1.append(LINEND);
                sb1.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + entry.getKey() + "\"" + LINEND);
                sb1.append("Content-Type: application/octet-stream; charset=" + CHARSET + LINEND);
                sb1.append(LINEND);
                outStream.write(sb1.toString().getBytes(this.inputCharset));
                outStream.write(Base64.getDecoder().decode(entry.getValue().getBytes(this.inputCharset)));
                outStream.write(LINEND.getBytes(this.inputCharset));
            }
        }
        byte[] byArray = (PREFIX + BOUNDARY + PREFIX + LINEND).getBytes(this.inputCharset);
        outStream.write(byArray);
        outStream.flush();
        outStream.close();
        InputStream inputStream = this.httpsURLConnection.getInputStream();
        byte[] bytes = IoUtil.read(inputStream, 1024);
        inputStream.close();
        return new String(bytes, this.inputCharset).trim();
    }

    public void setConnectTimeoutLimit(int connectTimeoutLimit) {
        this.connectTimeoutLimit = connectTimeoutLimit;
    }

    public void setReadTimeoutLimit(int readTimeoutLimit) {
        this.readTimeoutLimit = readTimeoutLimit;
    }
}

