/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.notice;

import com.alibaba.fastjson.JSONObject;
import cpcn.dsp.institution.api.codec.Base64;
import cpcn.dsp.institution.api.security.SignatureFactory;
import cpcn.dsp.institution.api.util.StringUtil;

public class NoticeRequest {
    private String plainText;
    private String txCode;
    private String code;
    private String message;

    public NoticeRequest(String message, String signature) throws Exception {
        byte[] data = Base64.decode(message);
        this.plainText = new String(data, "UTF-8");
        byte[] signatureData = StringUtil.hex2bytes(signature);
        if (!SignatureFactory.getVerifier().verify(data, signatureData)) {
            throw new Exception("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\u3002");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)this.plainText);
        this.code = jsonObject.getString("Code");
        this.txCode = jsonObject.getString("TxCode");
        this.message = jsonObject.getString("Message");
    }

    public NoticeRequest(String message, String signature, String dgtlEnvlp, String signSN, String encryptSN) throws Exception {
        this.plainText = SignatureFactory.getSigner(encryptSN).decrypt(message, dgtlEnvlp);
        if (!SignatureFactory.getVerifier().verify(this.plainText, signature)) {
            throw new Exception("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\u3002");
        }
        String document = this.plainText;
        JSONObject jsonObject = JSONObject.parseObject((String)document);
        this.code = jsonObject.getString("Code");
        message = jsonObject.getString("Message");
        this.txCode = jsonObject.getString("TxCode");
    }

    public String getPlainText() {
        return this.plainText;
    }

    public String getTxCode() {
        return this.txCode;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }
}

