/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.tx.score;

import cpcn.dsp.institution.api.security.SignatureFactory;
import cpcn.dsp.institution.api.util.StringUtil;
import org.apache.log4j.Logger;

public abstract class ScoreTxBaseRequest {
    protected static final Logger logger = Logger.getLogger((String)"system");
    protected String txCode;
    private String txSN;
    protected String requestPlainText;
    protected String requestMessage;
    protected String requestSignature;
    protected String requestDgtlEnvlp;
    protected String requestSignSN;
    protected String requestEncryptSN;

    public String getRequestPlainText() {
        return this.requestPlainText;
    }

    public String getRequestMessage() {
        return this.requestMessage;
    }

    public String getRequestSignature() {
        return this.requestSignature;
    }

    public String getRequestDgtlEnvlp() {
        return this.requestDgtlEnvlp;
    }

    public String getRequestSignSN() {
        return this.requestSignSN;
    }

    public String getRequestEncryptSN() {
        return this.requestEncryptSN;
    }

    public String getTxCode() {
        return this.txCode;
    }

    public void setTxCode(String txCode) {
        this.txCode = txCode;
    }

    public String getTxSN() {
        return this.txSN;
    }

    public void setTxSN(String txSN) {
        this.txSN = txSN;
    }

    public abstract void process() throws Exception;

    protected void postProcess(String document) throws Exception {
        this.requestPlainText = document;
        byte[] data = this.requestPlainText.getBytes("UTF-8");
        this.requestSignSN = SignatureFactory.getSigner().getSN();
        this.requestEncryptSN = SignatureFactory.getVerifier().getSN();
        String randomKeyData = SignatureFactory.getSigner().getSymmetricCipher();
        byte[] randomKey = randomKeyData.getBytes("UTF-8");
        this.requestDgtlEnvlp = SignatureFactory.getVerifier(this.requestEncryptSN).asymmetricEncrypt(randomKey);
        this.requestMessage = SignatureFactory.getVerifier(this.requestEncryptSN).symmetricEncrypt(this.requestPlainText, randomKeyData);
        byte[] signature = SignatureFactory.getSigner().sign(data);
        this.requestSignature = StringUtil.bytes2hex(signature);
    }
}

