/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.tsp.MessageImprint;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.timestamp.client.SSLContextManager;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import cfca.sadk.timestamp.exception.TSAVerifiedException;
import cfca.sadk.timestamp.exception.TSAVerifiedSubCode;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509CRLFile;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.io.IOException;
import java.security.PrivateKey;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class BusinessTrustCerts {
    private static final int crlCacheFileSize = 5120000;
    private X509CRLFile x509CRL;
    private X509Cert trustCert;
    private PrivateKey signedPrivateKey;
    private X509Cert signedCert;
    private final Session session;

    BusinessTrustCerts(String trustCertPath, String trustCRLPath) throws TSAException {
        this.setTrustCertPath(trustCertPath);
        this.setTrustCRLPath(trustCRLPath);
        this.session = BCSoftLib.INSTANCE();
    }

    final byte[] signedP7Detach(MessageImprint mssageImprint, ASN1Integer nonceValue) throws TSAException {
        byte[] signedDataBytes;
        byte[] hashValue;
        SM3Digest digest;
        String signAlg;
        byte[] nonceBytes;
        byte[] mssageImprintBytes;
        if (this.signedPrivateKey == null) {
            throw new TSAException(TSAErrorCode.signedFailureMissingSignedPrivateKey, "required signedPrivateKey");
        }
        if (this.signedCert == null) {
            throw new TSAException(TSAErrorCode.signedFailureMissingSignedCert, "required signedCert");
        }
        boolean validate = this.verifyCertValidate(this.signedCert, false);
        if (!validate) {
            throw new TSAException(TSAErrorCode.signedFailureInvalidCertValidate, "signedCert validate invalid");
        }
        if (mssageImprint == null) {
            throw new TSAException(TSAErrorCode.signedFailureMissingMessageImprint, "required mssageImprint");
        }
        if (nonceValue == null) {
            throw new TSAException(TSAErrorCode.signedFailureMissingNonceOptional, "required optional nonceValue ");
        }
        try {
            mssageImprintBytes = mssageImprint.getEncoded();
        }
        catch (IOException e) {
            throw new TSAException(TSAErrorCode.signedFailureGetEncodedMessageImprint, "mssageImprint encoded", (Throwable)e);
        }
        try {
            nonceBytes = nonceValue.getEncoded();
        }
        catch (IOException e) {
            throw new TSAException(TSAErrorCode.signedFailureGetEncodedNonceOptional, "nonceOptional encoded", (Throwable)e);
        }
        if (this.signedCert.isSM2Cert()) {
            signAlg = "sm3WithSM2Encryption";
            digest = new SM3Digest();
        } else {
            signAlg = "sha256WithRSAEncryption";
            digest = new SHA256Digest();
        }
        try {
            digest.update(mssageImprintBytes, 0, mssageImprintBytes.length);
            digest.update(nonceBytes, 0, nonceBytes.length);
            hashValue = new byte[digest.getDigestSize()];
            digest.doFinal(hashValue, 0);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.signedFailureHashedMessage, "done hashedMessage failure", (Throwable)e);
        }
        try {
            Signature signature = new Signature();
            signedDataBytes = signature.p7SignByHash(signAlg, hashValue, this.signedPrivateKey, this.signedCert, this.session);
            signedDataBytes = Base64.decode((byte[])signedDataBytes);
        }
        catch (PKIException e) {
            throw new TSAException(TSAErrorCode.signedFailureP7SignByHash, "done p7SignByHash failure", (Throwable)e);
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.signedFailureP7SignByHash, "done p7SignByHash failure", (Throwable)e);
        }
        return signedDataBytes;
    }

    final boolean verifyCertSignature(X509Cert x509Cert) throws TSAVerifiedException {
        boolean verifiedResult;
        if (x509Cert != null && this.trustCert != null) {
            try {
                verifiedResult = x509Cert.verify(this.trustCert.getPublicKey());
            }
            catch (Exception e) {
                throw new TSAVerifiedException(TSAVerifiedSubCode.timestampSignedCertSignatureInvalid, "x509Cert signature verify failure: " + e.getMessage(), (Throwable)e);
            }
        } else {
            verifiedResult = true;
        }
        return verifiedResult;
    }

    final boolean verifyCertValidate(X509Cert x509Cert, boolean withTrustCertValidate) throws TSAVerifiedException {
        Date nowTime = new Date();
        boolean verifiedResult = false;
        if (x509Cert != null) {
            if (x509Cert.getNotBefore().after(nowTime)) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
                throw new TSAVerifiedException(TSAVerifiedSubCode.timestampSignedCertValidateInvalid, String.format("x509Cert validate notBefore invalid: {signerCert=%s, nowTime=%s}", dateFormat.format(x509Cert.getNotBefore()), dateFormat.format(nowTime)));
            }
            if (x509Cert.getNotAfter().before(nowTime)) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
                throw new TSAVerifiedException(TSAVerifiedSubCode.timestampSignedCertValidateInvalid, String.format("x509Cert validate notAfter invalid: {signerCert=%s, nowTime=%s}", dateFormat.format(x509Cert.getNotAfter()), dateFormat.format(nowTime)));
            }
            if (withTrustCertValidate && x509Cert != null && this.trustCert != null) {
                if (x509Cert.getNotBefore().before(this.trustCert.getNotBefore())) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
                    throw new TSAVerifiedException(TSAVerifiedSubCode.timestampSignedCertValidateInvalid, String.format("x509Cert validate notBefore invalid: {signerCert=%s, trustCert=%s}", dateFormat.format(x509Cert.getNotBefore()), dateFormat.format(this.trustCert.getNotBefore())));
                }
                if (x509Cert.getNotAfter().after(this.trustCert.getNotAfter())) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
                    throw new TSAVerifiedException(TSAVerifiedSubCode.timestampSignedCertValidateInvalid, String.format("x509Cert validate notAfter invalid: {signerCert=%s, trustCert=%s}", dateFormat.format(x509Cert.getNotAfter()), dateFormat.format(this.trustCert.getNotAfter())));
                }
                verifiedResult = true;
            } else {
                verifiedResult = true;
            }
        }
        return verifiedResult;
    }

    final boolean isRevoke(X509Cert x509Cert) throws TSAVerifiedException {
        boolean verifiedResult;
        if (x509Cert != null && this.x509CRL != null) {
            try {
                verifiedResult = this.x509CRL.isRevoke(x509Cert.getSerialNumber());
            }
            catch (Exception e) {
                throw new TSAVerifiedException(TSAVerifiedSubCode.timestampSignedCertRevokeStatusInvalid, "x509Cert check revoked failure: " + e.getMessage(), (Throwable)e);
            }
        } else {
            verifiedResult = false;
        }
        return verifiedResult;
    }

    public final void setBusinessSignedCert(String signedCertFilePath, String signedFilePassword) throws TSAException {
        if (SSLContextManager.isEmpty(signedCertFilePath)) {
            this.signedPrivateKey = null;
            this.signedCert = null;
        } else {
            String path = signedCertFilePath.toLowerCase();
            X509Cert signedCert = null;
            Object signedPrivateKey = null;
            if (path.endsWith(".sm2")) {
                try {
                    signedPrivateKey = KeyUtil.getPrivateKeyFromSM2((String)signedCertFilePath, (String)signedFilePassword);
                }
                catch (PKIException e) {
                    throw new TSAException(TSAErrorCode.businessTrustGetSM2PrivatekeyFailure, "signedCertFilePath invalid: " + signedCertFilePath, (Throwable)e);
                }
                catch (Exception e) {
                    throw new TSAException(TSAErrorCode.businessTrustGetSM2PrivatekeyFailure, "signedCertFilePath invalid" + signedCertFilePath, (Throwable)e);
                }
                try {
                    signedCert = CertUtil.getCertFromSM2((String)signedCertFilePath);
                }
                catch (PKIException e) {
                    throw new TSAException(TSAErrorCode.businessTrustGetSM2CertFailure, "signedCertFilePath invalid: " + signedCertFilePath, (Throwable)e);
                }
                catch (Exception e) {
                    throw new TSAException(TSAErrorCode.businessTrustGetSM2CertFailure, "signedCertFilePath invalid" + signedCertFilePath, (Throwable)e);
                }
                this.setBusinessSignedCert(signedCert, (PrivateKey)signedPrivateKey);
            } else if (path.endsWith(".p12") || path.endsWith(".pfx")) {
                try {
                    signedPrivateKey = KeyUtil.getPrivateKeyFromPFX((String)signedCertFilePath, (String)signedFilePassword);
                }
                catch (PKIException e) {
                    throw new TSAException(TSAErrorCode.businessTrustGetRSAPrivatekeyFailure, "signedCertFilePath invalid: " + signedCertFilePath, (Throwable)e);
                }
                catch (Exception e) {
                    throw new TSAException(TSAErrorCode.businessTrustGetRSAPrivatekeyFailure, "signedCertFilePath invalid" + signedCertFilePath, (Throwable)e);
                }
                try {
                    signedCert = CertUtil.getCertFromPFX((String)signedCertFilePath, (String)signedFilePassword);
                }
                catch (PKIException e) {
                    throw new TSAException(TSAErrorCode.businessTrustGetRSACertFailure, "signedCertFilePath invalid: " + signedCertFilePath, (Throwable)e);
                }
                catch (Exception e) {
                    throw new TSAException(TSAErrorCode.businessTrustGetRSACertFailure, "signedCertFilePath invalid" + signedCertFilePath, (Throwable)e);
                }
                this.setBusinessSignedCert(signedCert, (PrivateKey)signedPrivateKey);
            } else {
                throw new TSAException(TSAErrorCode.businessTrustFilenameInvalid, "signedCertFilePath required end with sm2/p12/pfx");
            }
        }
    }

    public final void setBusinessSignedCert(X509Cert signedCert, PrivateKey signedPrivateKey) throws TSAException {
        if (signedCert != null && signedPrivateKey != null) {
            boolean verifiedResult;
            byte[] signedData;
            Mechanism mechanism;
            byte[] sourceData = "TESTING".getBytes();
            if (signedCert.isSM2Cert()) {
                mechanism = new Mechanism("sm3WithSM2Encryption");
                try {
                    signedData = this.session.sign(mechanism, signedPrivateKey, sourceData);
                }
                catch (Exception e) {
                    throw new TSAException(TSAErrorCode.businessTrustSM2FileCheckingSignedFailure, "SM2Cert signature failure: " + e.getMessage(), (Throwable)e);
                }
                try {
                    verifiedResult = this.session.verify(mechanism, signedCert.getPublicKey(), sourceData, signedData);
                }
                catch (Exception e) {
                    throw new TSAException(TSAErrorCode.businessTrustSM2FileCheckingVerifyFailure, "SM2Cert verify failure" + e.getMessage(), (Throwable)e);
                }
                if (!verifiedResult) {
                    throw new TSAException(TSAErrorCode.businessTrustSM2FileCheckingNotMatch, "SM2Cert/SM2PrivateKey not match");
                }
                this.signedCert = signedCert;
                this.signedPrivateKey = signedPrivateKey;
            }
            if (signedCert.isRSACert()) {
                mechanism = new Mechanism("sha256WithRSAEncryption");
                try {
                    signedData = this.session.sign(mechanism, signedPrivateKey, sourceData);
                }
                catch (Exception e) {
                    throw new TSAException(TSAErrorCode.businessTrustRSAFileCheckingSignedFailure, "RSACert signature failure: " + e.getMessage(), (Throwable)e);
                }
                try {
                    verifiedResult = this.session.verify(mechanism, signedCert.getPublicKey(), sourceData, signedData);
                }
                catch (Exception e) {
                    throw new TSAException(TSAErrorCode.businessTrustRSAFileCheckingVerifyFailure, "RSACert verify failure" + e.getMessage(), (Throwable)e);
                }
                if (!verifiedResult) {
                    throw new TSAException(TSAErrorCode.businessTrustRSAFileCheckingNotMatch, "RSACert/RSAPrivateKey not match");
                }
                this.signedCert = signedCert;
                this.signedPrivateKey = signedPrivateKey;
            }
        }
    }

    public final void setTrustCert(X509Cert trustCert) throws TSAException {
        this.trustCert = trustCert;
    }

    public final void setTrustCertPath(String trustCertPath) throws TSAException {
        X509Cert trustCert = null;
        if (trustCertPath != null && trustCertPath.length() != 0) {
            File trustCertFile = new File(trustCertPath);
            if (trustCertFile.exists() && trustCertFile.isFile()) {
                try {
                    trustCert = new X509Cert(trustCertPath);
                }
                catch (Exception e) {
                    throw new TSAException(TSAErrorCode.businessTrustCertFileInvalid, "trustCertFile " + trustCertFile + " invalid: " + e.getMessage(), (Throwable)e);
                }
            } else {
                throw new TSAException(TSAErrorCode.businessTrustCertFileInvalid, "trustCertFile " + trustCertFile + " invalid!!!");
            }
        }
        this.trustCert = trustCert;
    }

    public final void setTrustCRL(X509CRLFile x509CRL) throws TSAException {
        this.x509CRL = x509CRL;
    }

    public final void setTrustCRLPath(String trustCRLPath) throws TSAException {
        X509CRLFile crlCert = null;
        if (trustCRLPath != null && trustCRLPath.length() != 0) {
            File trustCRLFile = new File(trustCRLPath);
            if (trustCRLFile.exists() && trustCRLFile.isFile()) {
                try {
                    boolean enableCacheCRL = trustCRLFile.length() < 5120000L;
                    crlCert = new X509CRLFile(trustCRLPath, enableCacheCRL);
                }
                catch (Exception e) {
                    throw new TSAException(TSAErrorCode.businessTrustCertFileInvalid, "trustCRLFile " + trustCRLFile + " invalid: " + e.getMessage(), (Throwable)e);
                }
                this.x509CRL = crlCert;
            } else {
                throw new TSAException(TSAErrorCode.businessTrustCertFileInvalid, "trustCRLFile " + trustCRLFile + " invalid!!!");
            }
        }
    }
}

