/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.tx.corpquery;

import com.alibaba.fastjson.JSONObject;
import cpcn.dsp.institution.api.tx.TxBaseResponse;
import cpcn.dsp.institution.api.util.JSONUtil;
import cpcn.dsp.institution.api.vo.OrgShareInfo;
import cpcn.dsp.institution.api.vo.SharePersonalInfo;
import java.util.ArrayList;

public class Tx1131Response
extends TxBaseResponse {
    private String institutionID;
    private String txSN;
    private String traceNo;
    private String responseCode;
    private String responseMessage;
    private ArrayList<OrgShareInfo> orgShareInfoList;
    private ArrayList<SharePersonalInfo> sharePersonalInfoList;

    public Tx1131Response(String responseMessage, String responseSignature) throws Exception {
        super(responseMessage, responseSignature);
    }

    public Tx1131Response(String responseMessage, String responseSignature, String responseDgtlEnvlp, String responseSignSN, String responseEncryptSN) throws Exception {
        super(responseMessage, responseSignature, responseDgtlEnvlp, responseSignSN, responseEncryptSN);
    }

    @Override
    protected void process(String document) throws Exception {
        if ("2000".equals(this.code)) {
            JSONObject jsonObject = JSONObject.parseObject((String)document);
            this.institutionID = jsonObject.getString("InstitutionID");
            this.txSN = jsonObject.getString("TxSN");
            this.traceNo = jsonObject.getString("TraceNo");
            this.responseCode = jsonObject.getString("ResponseCode");
            this.responseMessage = jsonObject.getString("ResponseMessage");
            this.orgShareInfoList = this.processOrgShareInfoList(jsonObject);
            this.sharePersonalInfoList = this.processSharePersonalInfoList(jsonObject);
        }
    }

    private ArrayList<OrgShareInfo> processOrgShareInfoList(JSONObject jsonObject) {
        return (ArrayList)JSONUtil.toList(jsonObject.getString("OrgShareInfoList"), OrgShareInfo.class);
    }

    private ArrayList<SharePersonalInfo> processSharePersonalInfoList(JSONObject jsonObject) {
        return (ArrayList)JSONUtil.toList(jsonObject.getString("SharePersonalInfoList"), SharePersonalInfo.class);
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public void setInstitutionID(String institutionID) {
        this.institutionID = institutionID;
    }

    public String getTxSN() {
        return this.txSN;
    }

    public void setTxSN(String txSN) {
        this.txSN = txSN;
    }

    public String getTraceNo() {
        return this.traceNo;
    }

    public void setTraceNo(String traceNo) {
        this.traceNo = traceNo;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public ArrayList<OrgShareInfo> getOrgShareInfoList() {
        return this.orgShareInfoList;
    }

    public void setOrgShareInfoList(ArrayList<OrgShareInfo> orgShareInfoList) {
        this.orgShareInfoList = orgShareInfoList;
    }

    public ArrayList<SharePersonalInfo> getSharePersonalInfoList() {
        return this.sharePersonalInfoList;
    }

    public void setSharePersonalInfoList(ArrayList<SharePersonalInfo> sharePersonalInfoList) {
        this.sharePersonalInfoList = sharePersonalInfoList;
    }
}

