/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.access.net;

import cfca.ch.qos.logback.access.joran.JoranConfigurator;
import cfca.ch.qos.logback.access.net.SocketNode;
import cfca.ch.qos.logback.access.spi.AccessContext;
import cfca.ch.qos.logback.core.joran.spi.JoranException;
import cfca.ch.qos.logback.core.util.StatusPrinter;
import cfca.logback.util.SystemUtil;
import java.net.ServerSocket;
import java.net.Socket;

public class SimpleSocketServer {
    public static final String FILENAME_POSTFIX_XML = ".xml";
    static int port;
    private static AccessContext basicContext;

    public static void main(String[] argv) throws Exception {
        if (argv.length == 2) {
            SimpleSocketServer.init(argv[0], argv[1]);
        } else {
            SimpleSocketServer.usage("Wrong number of arguments.");
        }
        SimpleSocketServer.runServer();
    }

    static void runServer() {
        try {
            SystemUtil.OUT.println("Listening on port " + port);
            ServerSocket serverSocket = new ServerSocket(port);
            while (true) {
                SystemUtil.OUT.println("Waiting to accept a new client.");
                Socket socket = serverSocket.accept();
                SystemUtil.OUT.println("Connected to client at " + socket.getInetAddress());
                SystemUtil.OUT.println("Starting new socket node.");
                new Thread(new SocketNode(socket, basicContext)).start();
            }
        }
        catch (Exception e) {
            SystemUtil.printStackTrace(e);
            return;
        }
    }

    static void usage(String msg) {
        SystemUtil.ERR.println(msg);
        SystemUtil.ERR.println("Usage: java " + SimpleSocketServer.class.getName() + " port configFile");
        System.exit(1);
    }

    static void init(String portStr, String configFile) throws JoranException {
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            SystemUtil.printStackTrace(e);
            SimpleSocketServer.usage("Could not interpret port number [" + portStr + "].");
        }
        basicContext = new AccessContext();
        if (configFile.endsWith(FILENAME_POSTFIX_XML)) {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(basicContext);
            configurator.doConfigure(configFile);
            StatusPrinter.print(basicContext);
        }
    }
}

