/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util.p12;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.pkcs.PKCS12;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.Base64;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.P10Request;
import cfca.sadk.util.p12.P12FileFacade;
import cfca.sadk.util.p12.P12FileUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public class P12FileRSAImpl
implements P12FileFacade {
    public String generateKeyPair(Mechanism algorithm, int bitLength, String password) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("RSAGenerateKeyPair>>>>>>Running: bitLength=" + bitLength);
        }
        try {
            byte[] pfxBytes;
            X509Cert cert;
            KeyPair keypair;
            Session session = P12FileUtil.session();
            if (bitLength != 1024 && bitLength != 2048 && bitLength != 4096) {
                throw new PKIException("PFX KeyPair Invalid bitLength=" + bitLength);
            }
            try {
                keypair = KeyUtil.generateKeyPair(new Mechanism("RSA"), bitLength, session);
            }
            catch (PKIException e) {
                throw new PKIException("PFX KeyPair generate failure:", e);
            }
            try {
                cert = P12FileUtil.signedMyselfCert(session, keypair, "RSA");
            }
            catch (Exception e) {
                throw new PKIException("PFX KeyPair signed myself failure", e);
            }
            try {
                pfxBytes = this.combineP12Data(cert, keypair.getPrivate(), password);
            }
            catch (Exception e) {
                throw new PKIException("PFX KeyPair failure", e);
            }
            String base64P12Text = Base64.toBase64String(pfxBytes);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("RSAGenerateKeyPair<<<<<<Finished: base64P12Text=" + base64P12Text);
            }
            return base64P12Text;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("RSAGenerateKeyPair<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSAGenerateKeyPair<<<<<<Failure", e);
            throw new PKIException("RSAGenerateKeyPair Failure", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String generateP10(String base64EncryptedKeyData, String password) throws PKIException {
        String string;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("RSAGenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
        }
        boolean isFailed = false;
        try {
            try {
                byte[] base64p10;
                PublicKey publicKey;
                PKCS12 P10;
                if (base64EncryptedKeyData == null) {
                    throw new PKIException("PFX P10 base64EncryptedKeyData should not be null");
                }
                if (password == null) {
                    throw new PKIException("PFX P10 password should not be null");
                }
                Session session = P12FileUtil.session();
                try {
                    P10 = new PKCS12();
                    P10.load(Strings.toByteArray(base64EncryptedKeyData));
                    P10.decrypt(password.toCharArray());
                }
                catch (Exception e) {
                    throw new PKIException("PFX P10 loading failure ", e);
                }
                PrivateKey privateKey = P10.getPrivateKey();
                try {
                    privateKey = P10.getPrivateKey();
                }
                catch (Exception e) {
                    throw new PKIException("PFX P10 Fatched PrivateKey failure", e);
                }
                try {
                    publicKey = P10.getCerts()[0].getPublicKey();
                }
                catch (Exception e) {
                    throw new PKIException("PFX P10 Fatched PublicKey failure", e);
                }
                String testDN = String.format("CN=certRequisition %s,O=CFCA RSA AGENT,C=CN", P12FileUtil.generateRandom());
                X500Name subject = new X500Name(testDN);
                P10Request p10R = new P10Request(session);
                try {
                    base64p10 = p10R.generatePKCS10Request(new Mechanism("sha256WithRSAEncryption"), subject, null, publicKey, privateKey, session);
                }
                catch (PKIException e) {
                    throw new PKIException("PFX P10 Generated PKCS10 failure ", e);
                }
                String base64RSAP10Text = Strings.fromByteArray(base64p10);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("RSAGenerateP10<<<<<<Finished: base64RSAP10Text=" + base64RSAP10Text);
                }
                string = base64RSAP10Text;
                Object var15_20 = null;
                if (!isFailed) return string;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSAGenerateP10<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSAGenerateP10<<<<<<Failure", e);
                throw new PKIException("RSAGenerateP10 Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            LoggerManager.exceptionLogger.error("RSAGenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return string;
        LoggerManager.exceptionLogger.error("RSAGenerateP10>>>>>>Running: base64EncryptedKeyData=" + base64EncryptedKeyData);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String combineP12(String base64EncryptedKeyData, String base64CertData, String password) throws PKIException {
        String string;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSACombineP12>>>>>>Running");
            buffer.append("\n base64EncryptedKeyData: ");
            buffer.append(SADKDebugger.dump(base64EncryptedKeyData));
            buffer.append("\n base64CertData: ");
            buffer.append(SADKDebugger.dump(base64CertData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                byte[] data;
                X509Cert cert;
                PKCS12 P10;
                try {
                    P10 = new PKCS12();
                    P10.load(Strings.toByteArray(base64EncryptedKeyData));
                    P10.decrypt(password.toCharArray());
                }
                catch (Exception e) {
                    throw new PKIException("PFX Combine loading base64EncryptedKeyData failure ", e);
                }
                PrivateKey privateKey = P10.getPrivateKey();
                try {
                    privateKey = P10.getPrivateKey();
                }
                catch (Exception e) {
                    throw new PKIException("PFX Combine Fatched PrivateKey failure", e);
                }
                try {
                    cert = new X509Cert(Strings.toByteArray(base64CertData));
                }
                catch (PKIException e) {
                    throw new PKIException("PFX Combine Decoded base64CertData failure", e);
                }
                try {
                    data = this.combineP12Data(cert, privateKey, password);
                }
                catch (Exception e) {
                    throw new PKIException("PFX Combine failure", e);
                }
                String base64RSAP12Text = Base64.toBase64String(data);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("SM2CombineP12<<<<<<Finished: base64RSAP12Text=" + base64RSAP12Text);
                }
                string = base64RSAP12Text;
                Object var12_18 = null;
                if (!isFailed) return string;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSACombineP12<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSACombineP12<<<<<<Failure", e);
                throw new PKIException("RSACombineP12 Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSACombineP12>>>>>>Running");
            buffer.append("\n base64EncryptedKeyData: ");
            buffer.append(SADKDebugger.dump(base64EncryptedKeyData));
            buffer.append("\n base64CertData: ");
            buffer.append(SADKDebugger.dump(base64CertData));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return string;
        StringBuffer buffer = new StringBuffer();
        buffer.append("RSACombineP12>>>>>>Running");
        buffer.append("\n base64EncryptedKeyData: ");
        buffer.append(SADKDebugger.dump(base64EncryptedKeyData));
        buffer.append("\n base64CertData: ");
        buffer.append(SADKDebugger.dump(base64CertData));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String combineP12File(X509Cert x509Cert, PrivateKey priKey, String password, String p12FileName) throws PKIException {
        String string;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSACombineP12File>>>>>>Running");
            buffer.append("\n x509Cert: ");
            buffer.append(SADKDebugger.dump(x509Cert));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                if (p12FileName == null) {
                    throw new PKIException("PFXFile fileName should not be null");
                }
                byte[] encoding = this.combineP12Data(x509Cert, priKey, password);
                try {
                    FileHelper.write(p12FileName, encoding);
                }
                catch (Exception e) {
                    throw new PKIException("PFXFile write failure", e);
                }
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("RSACombineP12File<<<<<<Finished: p12FileName=" + p12FileName);
                }
                string = p12FileName;
                Object var9_12 = null;
                if (!isFailed) return string;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSACombineP12File<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSACombineP12File<<<<<<Failure", e);
                throw new PKIException("RSACombineP12File Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSACombineP12File>>>>>>Running");
            buffer.append("\n x509Cert: ");
            buffer.append(SADKDebugger.dump(x509Cert));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return string;
        StringBuffer buffer = new StringBuffer();
        buffer.append("RSACombineP12File>>>>>>Running");
        buffer.append("\n x509Cert: ");
        buffer.append(SADKDebugger.dump(x509Cert));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] combineP12Data(X509Cert x509Cert, PrivateKey priKey, String password) throws PKIException {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSACombineP12Data>>>>>>Running");
            buffer.append("\n x509Cert: ");
            buffer.append(SADKDebugger.dump(x509Cert));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                if (x509Cert == null) throw new PKIException("x509Cert is not RSAType");
                if (!x509Cert.isRSACert()) {
                    throw new PKIException("x509Cert is not RSAType");
                }
                byte[] binaryP12Data = PKCS12.generatePfxData(x509Cert, priKey, password);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("RSACombineP12Data<<<<<<Finished: binaryP12Data=" + SADKDebugger.dump(binaryP12Data));
                }
                byArray = binaryP12Data;
                Object var8_10 = null;
                if (!isFailed) return byArray;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSACombineP12Data<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("RSACombineP12Data<<<<<<Failure", e);
                throw new PKIException("RSACombineP12Data Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSACombineP12Data>>>>>>Running");
            buffer.append("\n x509Cert: ");
            buffer.append(SADKDebugger.dump(x509Cert));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
        StringBuffer buffer = new StringBuffer();
        buffer.append("RSACombineP12Data>>>>>>Running");
        buffer.append("\n x509Cert: ");
        buffer.append(SADKDebugger.dump(x509Cert));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return byArray;
    }
}

