/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.keystore.pkcs12;

import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.BEROctetString;
import cfca.sadk.org.bouncycastle.asn1.BEROutputStream;
import cfca.sadk.org.bouncycastle.asn1.DERBMPString;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import cfca.sadk.org.bouncycastle.asn1.pkcs.CertBag;
import cfca.sadk.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.EncryptedData;
import cfca.sadk.org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.MacData;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PBES2Parameters;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.Pfx;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SafeBag;
import cfca.sadk.org.bouncycastle.asn1.util.ASN1Dump;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.DigestInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.util.SecretKeyUtil;
import cfca.sadk.org.bouncycastle.jce.interfaces.BCKeyStore;
import cfca.sadk.org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS12KeyStoreSpi
extends KeyStoreSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
BCKeyStore {
    private static final int SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 1024;
    private static final Provider bcProvider = new BouncyCastleProvider();
    private IgnoresCaseHashtable keys = new IgnoresCaseHashtable();
    private ConcurrentHashMap<String, String> localIds = new ConcurrentHashMap();
    private IgnoresCaseHashtable certs = new IgnoresCaseHashtable();
    private ConcurrentHashMap<CertId, Certificate> chainCerts = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Certificate> keyCerts = new ConcurrentHashMap();
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected SecureRandom random = new SecureRandom();
    private CertificateFactory certFact;
    private ASN1ObjectIdentifier keyAlgorithm;
    private ASN1ObjectIdentifier certAlgorithm;

    public PKCS12KeyStoreSpi(Provider provider, ASN1ObjectIdentifier keyAlgorithm, ASN1ObjectIdentifier certAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        this.certAlgorithm = certAlgorithm;
        try {
            this.certFact = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't create cert factory - " + e.toString());
        }
    }

    private SubjectKeyIdentifier createSubjectKeyId(PublicKey pubKey) {
        try {
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo((ASN1Sequence)ASN1Primitive.fromByteArray(pubKey.getEncoded()));
            return new SubjectKeyIdentifier(PKCS12KeyStoreSpi.getDigest(info));
        }
        catch (Exception e) {
            throw new RuntimeException("error creating key");
        }
    }

    private static byte[] getDigest(SubjectPublicKeyInfo spki) {
        SHA1Digest digest = new SHA1Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        byte[] bytes = spki.getPublicKeyData().getBytes();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        return resBuf;
    }

    public void setRandom(SecureRandom rand) {
        this.random = rand;
    }

    public Enumeration engineAliases() {
        ConcurrentHashMap<String, String> tab = new ConcurrentHashMap<String, String>();
        Enumeration<String> e = this.certs.keys();
        while (e.hasMoreElements()) {
            tab.put(e.nextElement(), "cert");
        }
        e = this.keys.keys();
        while (e.hasMoreElements()) {
            String a = e.nextElement();
            if (tab.get(a) != null) continue;
            tab.put(a, "key");
        }
        return tab.keys();
    }

    public boolean engineContainsAlias(String alias) {
        return this.certs.get(alias) != null || this.keys.get(alias) != null;
    }

    public void engineDeleteEntry(String alias) throws KeyStoreException {
        Key k = (Key)this.keys.remove(alias);
        Certificate c = (Certificate)this.certs.remove(alias);
        if (c != null) {
            this.chainCerts.remove(new CertId(c.getPublicKey()));
        }
        if (k != null) {
            String id = this.localIds.remove(alias);
            if (id != null) {
                c = this.keyCerts.remove(id);
            }
            if (c != null) {
                this.chainCerts.remove(new CertId(c.getPublicKey()));
            }
        }
    }

    public Certificate engineGetCertificate(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("null alias passed to getCertificate.");
        }
        Certificate c = (Certificate)this.certs.get(alias);
        if (c == null) {
            String id = this.localIds.get(alias);
            c = id != null ? this.keyCerts.get(id) : this.keyCerts.get(alias);
        }
        return c;
    }

    public String engineGetCertificateAlias(Certificate cert) {
        String ta;
        Certificate tc;
        Enumeration<Certificate> c = this.certs.elements();
        Enumeration<String> k = this.certs.keys();
        while (c.hasMoreElements()) {
            tc = (Certificate)c.nextElement();
            ta = k.nextElement();
            if (!tc.equals(cert)) continue;
            return ta;
        }
        c = this.keyCerts.elements();
        k = this.keyCerts.keys();
        while (c.hasMoreElements()) {
            tc = c.nextElement();
            ta = k.nextElement();
            if (!tc.equals(cert)) continue;
            return ta;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("null alias passed to getCertificateChain.");
        }
        if (!this.engineIsKeyEntry(alias)) {
            return null;
        }
        Certificate c = this.engineGetCertificate(alias);
        if (c != null) {
            Vector<Certificate> cs = new Vector<Certificate>();
            while (c != null) {
                Principal s;
                Principal i;
                X509Certificate x509c = (X509Certificate)c;
                Certificate nextC = null;
                byte[] bytes = x509c.getExtensionValue(Extension.authorityKeyIdentifier.getId());
                if (bytes != null) {
                    try {
                        ASN1InputStream aIn = new ASN1InputStream(bytes);
                        byte[] authBytes = ((ASN1OctetString)aIn.readObject()).getOctets();
                        aIn = new ASN1InputStream(authBytes);
                        AuthorityKeyIdentifier id = AuthorityKeyIdentifier.getInstance(aIn.readObject());
                        if (id.getKeyIdentifier() != null) {
                            nextC = this.chainCerts.get(new CertId(id.getKeyIdentifier()));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e.toString());
                    }
                }
                if (nextC == null && !(i = x509c.getIssuerDN()).equals(s = x509c.getSubjectDN())) {
                    Enumeration<CertId> e = this.chainCerts.keys();
                    while (e.hasMoreElements()) {
                        X509Certificate crt = (X509Certificate)this.chainCerts.get(e.nextElement());
                        Principal sub = crt.getSubjectDN();
                        if (!sub.equals(i)) continue;
                        try {
                            x509c.verify(crt.getPublicKey());
                            nextC = crt;
                            break;
                        }
                        catch (Exception ex) {
                        }
                    }
                }
                cs.addElement(c);
                if (nextC != c) {
                    c = nextC;
                    continue;
                }
                c = null;
            }
            Certificate[] certChain = new Certificate[cs.size()];
            for (int i = 0; i != certChain.length; ++i) {
                certChain[i] = (Certificate)cs.elementAt(i);
            }
            return certChain;
        }
        return null;
    }

    public Date engineGetCreationDate(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        if (this.keys.get(alias) == null && this.certs.get(alias) == null) {
            return null;
        }
        return new Date();
    }

    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (alias == null) {
            throw new IllegalArgumentException("null alias passed to getKey.");
        }
        return (Key)this.keys.get(alias);
    }

    public boolean engineIsCertificateEntry(String alias) {
        return this.certs.get(alias) != null && this.keys.get(alias) == null;
    }

    public boolean engineIsKeyEntry(String alias) {
        return this.keys.get(alias) != null;
    }

    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (this.keys.get(alias) != null) {
            throw new KeyStoreException("There is a key entry with the name " + alias + ".");
        }
        this.certs.put(alias, cert);
        this.chainCerts.put(new CertId(cert.getPublicKey()), cert);
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new RuntimeException("operation not supported");
    }

    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("PKCS12 does not support non-PrivateKeys");
        }
        if (key instanceof PrivateKey && chain == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        if (this.keys.get(alias) != null) {
            this.engineDeleteEntry(alias);
        }
        this.keys.put(alias, key);
        if (chain != null) {
            this.certs.put(alias, chain[0]);
            for (int i = 0; i != chain.length; ++i) {
                this.chainCerts.put(new CertId(chain[i].getPublicKey()), chain[i]);
            }
        }
    }

    public int engineSize() {
        ConcurrentHashMap<String, String> tab = new ConcurrentHashMap<String, String>();
        Enumeration<String> e = this.certs.keys();
        while (e.hasMoreElements()) {
            tab.put(e.nextElement(), "cert");
        }
        e = this.keys.keys();
        while (e.hasMoreElements()) {
            String a = e.nextElement();
            if (tab.get(a) != null) continue;
            tab.put(a, "key");
        }
        return tab.size();
    }

    protected PrivateKey unwrapKey(AlgorithmIdentifier algId, byte[] data, char[] password, boolean wrongPKCS12Zero) throws IOException {
        ASN1ObjectIdentifier algorithm = algId.getAlgorithm();
        try {
            if (algorithm.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algId.getParameters());
                PBEKeySpec pbeSpec = new PBEKeySpec(password);
                SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm.getId(), bcProvider);
                PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
                SecretKey k = keyFact.generateSecret(pbeSpec);
                ((BCPBEKey)k).setTryWrongPKCS12Zero(wrongPKCS12Zero);
                Cipher cipher = Cipher.getInstance(algorithm.getId(), bcProvider);
                cipher.init(4, (Key)k, defParams);
                return (PrivateKey)cipher.unwrap(data, "", 2);
            }
            if (algorithm.equals(PKCSObjectIdentifiers.id_PBES2)) {
                PBES2Parameters alg = PBES2Parameters.getInstance(algId.getParameters());
                PBKDF2Params func = PBKDF2Params.getInstance(alg.getKeyDerivationFunc().getParameters());
                SecretKeyFactory keyFact = SecretKeyFactory.getInstance(alg.getKeyDerivationFunc().getAlgorithm().getId(), bcProvider);
                SecretKey k = keyFact.generateSecret(new PBEKeySpec(password, func.getSalt(), func.getIterationCount().intValue(), SecretKeyUtil.getKeySize(alg.getEncryptionScheme().getAlgorithm())));
                Cipher cipher = Cipher.getInstance(alg.getEncryptionScheme().getAlgorithm().getId(), bcProvider);
                cipher.init(4, (Key)k, new IvParameterSpec(ASN1OctetString.getInstance(alg.getEncryptionScheme().getParameters()).getOctets()));
                return (PrivateKey)cipher.unwrap(data, "", 2);
            }
        }
        catch (Exception e) {
            throw new IOException("exception unwrapping private key - " + e.toString());
        }
        throw new IOException("exception unwrapping private key - cannot recognise: " + algorithm);
    }

    protected byte[] wrapKey(String algorithm, Key key, PKCS12PBEParams pbeParams, char[] password) throws IOException {
        byte[] out;
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        try {
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, bcProvider);
            PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(algorithm, bcProvider);
            cipher.init(3, (Key)keyFact.generateSecret(pbeSpec), defParams);
            out = cipher.wrap(key);
        }
        catch (Exception e) {
            throw new IOException("exception encrypting data - " + e.toString());
        }
        return out;
    }

    protected byte[] cryptData(boolean forEncryption, AlgorithmIdentifier algId, char[] password, boolean wrongPKCS12Zero, byte[] data) throws IOException {
        String algorithm = algId.getAlgorithm().getId();
        PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algId.getParameters());
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        try {
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, bcProvider);
            PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
            BCPBEKey key = (BCPBEKey)keyFact.generateSecret(pbeSpec);
            key.setTryWrongPKCS12Zero(wrongPKCS12Zero);
            Cipher cipher = Cipher.getInstance(algorithm, bcProvider);
            int mode = forEncryption ? 1 : 2;
            cipher.init(mode, (Key)key, defParams);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new IOException("exception decrypting data - " + e.toString());
        }
    }

    public void engineLoad(InputStream stream, char[] password) throws IOException {
        PKCS12BagAttributeCarrier bagAttr;
        if (stream == null) {
            return;
        }
        if (password == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        BufferedInputStream bufIn = new BufferedInputStream(stream);
        bufIn.mark(10);
        int head = bufIn.read();
        if (head != 48) {
            throw new IOException("stream does not represent a PKCS12 key store");
        }
        bufIn.reset();
        ASN1InputStream bIn = new ASN1InputStream(bufIn);
        ASN1Sequence obj = (ASN1Sequence)bIn.readObject();
        Pfx bag = Pfx.getInstance(obj);
        ContentInfo info = bag.getAuthSafe();
        Vector<SafeBag> chain = new Vector<SafeBag>();
        boolean unmarkedKey = false;
        boolean wrongPKCS12Zero = false;
        if (bag.getMacData() != null) {
            MacData mData = bag.getMacData();
            DigestInfo dInfo = mData.getMac();
            AlgorithmIdentifier algId = dInfo.getAlgorithmId();
            byte[] salt = mData.getSalt();
            int itCount = mData.getIterationCount().intValue();
            byte[] data = ((ASN1OctetString)info.getContent()).getOctets();
            try {
                byte[] res = PKCS12KeyStoreSpi.calculatePbeMac(algId.getAlgorithm(), salt, itCount, password, false, data);
                byte[] dig = dInfo.getDigest();
                if (!Arrays.constantTimeAreEqual(res, dig)) {
                    if (password.length > 0) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    res = PKCS12KeyStoreSpi.calculatePbeMac(algId.getAlgorithm(), salt, itCount, password, true, data);
                    if (!Arrays.constantTimeAreEqual(res, dig)) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    wrongPKCS12Zero = true;
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("error constructing MAC: " + e.toString());
            }
        }
        this.keys = new IgnoresCaseHashtable();
        this.localIds = new ConcurrentHashMap();
        if (info.getContentType().equals(data)) {
            bIn = new ASN1InputStream(((ASN1OctetString)info.getContent()).getOctets());
            AuthenticatedSafe authSafe = AuthenticatedSafe.getInstance(bIn.readObject());
            ContentInfo[] c = authSafe.getContentInfo();
            for (int i = 0; i != c.length; ++i) {
                if (c[i].getContentType().equals(data)) {
                    ASN1InputStream dIn = new ASN1InputStream(((ASN1OctetString)c[i].getContent()).getOctets());
                    ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
                    for (int j = 0; j != seq.size(); ++j) {
                        SafeBag b = SafeBag.getInstance(seq.getObjectAt(j));
                        if (b.getBagId().equals(pkcs8ShroudedKeyBag)) {
                            EncryptedPrivateKeyInfo eIn = EncryptedPrivateKeyInfo.getInstance(b.getBagValue());
                            PrivateKey privKey = this.unwrapKey(eIn.getEncryptionAlgorithm(), eIn.getEncryptedData(), password, wrongPKCS12Zero);
                            PKCS12BagAttributeCarrier bagAttr2 = (PKCS12BagAttributeCarrier)((Object)privKey);
                            String alias = null;
                            ASN1OctetString localId = null;
                            if (b.getBagAttributes() != null) {
                                Enumeration e = b.getBagAttributes().getObjects();
                                while (e.hasMoreElements()) {
                                    ASN1Sequence sq = (ASN1Sequence)e.nextElement();
                                    ASN1ObjectIdentifier aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                                    ASN1Set attrSet = (ASN1Set)sq.getObjectAt(1);
                                    ASN1Primitive attr = null;
                                    if (attrSet.size() > 0) {
                                        attr = (ASN1Primitive)attrSet.getObjectAt(0);
                                        ASN1Encodable existing = bagAttr2.getBagAttribute(aOid);
                                        if (existing != null) {
                                            if (!existing.toASN1Primitive().equals(attr)) {
                                                throw new IOException("attempt to add existing attribute with different value");
                                            }
                                        } else {
                                            bagAttr2.setBagAttribute(aOid, attr);
                                        }
                                    }
                                    if (aOid.equals(pkcs_9_at_friendlyName)) {
                                        alias = ((DERBMPString)attr).getString();
                                        this.keys.put(alias, privKey);
                                        continue;
                                    }
                                    if (!aOid.equals(pkcs_9_at_localKeyId)) continue;
                                    localId = (ASN1OctetString)attr;
                                }
                            }
                            if (localId != null) {
                                String name = Hex.toHexString(localId.getOctets());
                                if (alias == null) {
                                    this.keys.put(name, privKey);
                                    continue;
                                }
                                this.localIds.put(alias, name);
                                continue;
                            }
                            unmarkedKey = true;
                            this.keys.put("unmarked", privKey);
                            continue;
                        }
                        if (b.getBagId().equals(certBag)) {
                            chain.addElement(b);
                            continue;
                        }
                        b.getBagId();
                        ASN1Dump.dumpAsString(b);
                    }
                    continue;
                }
                if (c[i].getContentType().equals(encryptedData)) {
                    EncryptedData d = EncryptedData.getInstance(c[i].getContent());
                    byte[] octets = this.cryptData(false, d.getEncryptionAlgorithm(), password, wrongPKCS12Zero, d.getContent().getOctets());
                    ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray(octets);
                    for (int j = 0; j != seq.size(); ++j) {
                        String name;
                        ASN1Encodable existing;
                        ASN1Primitive attr;
                        ASN1Set attrSet;
                        ASN1ObjectIdentifier aOid;
                        ASN1Sequence sq;
                        Enumeration e;
                        ASN1OctetString localId;
                        String alias;
                        PrivateKey privKey;
                        SafeBag b = SafeBag.getInstance(seq.getObjectAt(j));
                        if (b.getBagId().equals(certBag)) {
                            chain.addElement(b);
                            continue;
                        }
                        if (b.getBagId().equals(pkcs8ShroudedKeyBag)) {
                            EncryptedPrivateKeyInfo eIn = EncryptedPrivateKeyInfo.getInstance(b.getBagValue());
                            privKey = this.unwrapKey(eIn.getEncryptionAlgorithm(), eIn.getEncryptedData(), password, wrongPKCS12Zero);
                            bagAttr = (PKCS12BagAttributeCarrier)((Object)privKey);
                            alias = null;
                            localId = null;
                            e = b.getBagAttributes().getObjects();
                            while (e.hasMoreElements()) {
                                sq = (ASN1Sequence)e.nextElement();
                                aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                                attrSet = (ASN1Set)sq.getObjectAt(1);
                                attr = null;
                                if (attrSet.size() > 0) {
                                    attr = (ASN1Primitive)attrSet.getObjectAt(0);
                                    existing = bagAttr.getBagAttribute(aOid);
                                    if (existing != null) {
                                        if (!existing.toASN1Primitive().equals(attr)) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                    } else {
                                        bagAttr.setBagAttribute(aOid, attr);
                                    }
                                }
                                if (aOid.equals(pkcs_9_at_friendlyName)) {
                                    alias = ((DERBMPString)attr).getString();
                                    this.keys.put(alias, privKey);
                                    continue;
                                }
                                if (!aOid.equals(pkcs_9_at_localKeyId)) continue;
                                localId = (ASN1OctetString)attr;
                            }
                            name = Hex.toHexString(localId.getOctets());
                            if (alias == null) {
                                this.keys.put(name, privKey);
                                continue;
                            }
                            this.localIds.put(alias, name);
                            continue;
                        }
                        if (b.getBagId().equals(keyBag)) {
                            PrivateKeyInfo kInfo = PrivateKeyInfo.getInstance(b.getBagValue());
                            privKey = BouncyCastleProvider.getPrivateKey(kInfo);
                            bagAttr = (PKCS12BagAttributeCarrier)((Object)privKey);
                            alias = null;
                            localId = null;
                            e = b.getBagAttributes().getObjects();
                            while (e.hasMoreElements()) {
                                sq = (ASN1Sequence)e.nextElement();
                                aOid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                                attrSet = (ASN1Set)sq.getObjectAt(1);
                                attr = null;
                                if (attrSet.size() > 0) {
                                    attr = (ASN1Primitive)attrSet.getObjectAt(0);
                                    existing = bagAttr.getBagAttribute(aOid);
                                    if (existing != null) {
                                        if (!existing.toASN1Primitive().equals(attr)) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                    } else {
                                        bagAttr.setBagAttribute(aOid, attr);
                                    }
                                }
                                if (aOid.equals(pkcs_9_at_friendlyName)) {
                                    alias = ((DERBMPString)attr).getString();
                                    this.keys.put(alias, privKey);
                                    continue;
                                }
                                if (!aOid.equals(pkcs_9_at_localKeyId)) continue;
                                localId = (ASN1OctetString)attr;
                            }
                            name = Hex.toHexString(localId.getOctets());
                            if (alias == null) {
                                this.keys.put(name, privKey);
                                continue;
                            }
                            this.localIds.put(alias, name);
                            continue;
                        }
                        b.getBagId();
                        ASN1Dump.dumpAsString(b);
                    }
                    continue;
                }
                c[i].getContentType().getId();
                ASN1Dump.dumpAsString(c[i].getContent());
            }
        }
        this.certs = new IgnoresCaseHashtable();
        this.chainCerts = new ConcurrentHashMap();
        this.keyCerts = new ConcurrentHashMap();
        for (int i = 0; i != chain.size(); ++i) {
            String name;
            Certificate cert;
            SafeBag b = (SafeBag)chain.elementAt(i);
            CertBag cb = CertBag.getInstance(b.getBagValue());
            if (!cb.getCertId().equals(x509Certificate)) {
                throw new RuntimeException("Unsupported certificate type: " + cb.getCertId());
            }
            try {
                ByteArrayInputStream cIn = new ByteArrayInputStream(((ASN1OctetString)cb.getCertValue()).getOctets());
                cert = this.certFact.generateCertificate(cIn);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
            ASN1OctetString localId = null;
            String alias = null;
            if (b.getBagAttributes() != null) {
                Enumeration e = b.getBagAttributes().getObjects();
                while (e.hasMoreElements()) {
                    ASN1Sequence sq = (ASN1Sequence)e.nextElement();
                    ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)sq.getObjectAt(0);
                    ASN1Primitive attr = (ASN1Primitive)((ASN1Set)sq.getObjectAt(1)).getObjectAt(0);
                    bagAttr = null;
                    if (cert instanceof PKCS12BagAttributeCarrier) {
                        bagAttr = (PKCS12BagAttributeCarrier)((Object)cert);
                        ASN1Encodable existing = bagAttr.getBagAttribute(oid);
                        if (existing != null) {
                            if (!existing.toASN1Primitive().equals(attr)) {
                                throw new IOException("attempt to add existing attribute with different value");
                            }
                        } else {
                            bagAttr.setBagAttribute(oid, attr);
                        }
                    }
                    if (oid.equals(pkcs_9_at_friendlyName)) {
                        alias = ((DERBMPString)attr).getString();
                        continue;
                    }
                    if (!oid.equals(pkcs_9_at_localKeyId)) continue;
                    localId = (ASN1OctetString)attr;
                }
            }
            this.chainCerts.put(new CertId(cert.getPublicKey()), cert);
            if (unmarkedKey) {
                if (!this.keyCerts.isEmpty()) continue;
                name = Hex.toHexString(this.createSubjectKeyId(cert.getPublicKey()).getKeyIdentifier());
                this.keyCerts.put(name, cert);
                this.keys.put(name, this.keys.remove("unmarked"));
                continue;
            }
            if (localId != null) {
                name = Hex.toHexString(localId.getOctets());
                this.keyCerts.put(name, cert);
            }
            if (alias == null) continue;
            this.certs.put(alias, cert);
        }
    }

    public void engineStore(OutputStream stream, char[] password) throws IOException {
        this.doStore(stream, password, false);
    }

    private void doStore(OutputStream stream, char[] password, boolean useDEREncoding) throws IOException {
        MacData mData;
        Object certId;
        SafeBag sBag;
        ASN1EncodableVector fSeq;
        ASN1EncodableVector fSeq2;
        ASN1ObjectIdentifier oid;
        Enumeration e;
        DERBMPString nm;
        PKCS12BagAttributeCarrier bagAttrs;
        ASN1EncodableVector fName;
        CertBag cBag;
        Certificate cert;
        if (password == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        ASN1EncodableVector keyS = new ASN1EncodableVector();
        Enumeration<String> ks = this.keys.keys();
        while (ks.hasMoreElements()) {
            byte[] kSalt = new byte[20];
            this.random.nextBytes(kSalt);
            String name = ks.nextElement();
            PrivateKey privKey = (PrivateKey)this.keys.get(name);
            PKCS12PBEParams kParams = new PKCS12PBEParams(kSalt, 1024);
            byte[] kBytes = this.wrapKey(this.keyAlgorithm.getId(), privKey, kParams, password);
            AlgorithmIdentifier kAlgId = new AlgorithmIdentifier(this.keyAlgorithm, kParams.toASN1Primitive());
            EncryptedPrivateKeyInfo kInfo = new EncryptedPrivateKeyInfo(kAlgId, kBytes);
            boolean attrSet = false;
            ASN1EncodableVector kName = new ASN1EncodableVector();
            if (privKey instanceof PKCS12BagAttributeCarrier) {
                PKCS12BagAttributeCarrier bagAttrs2 = (PKCS12BagAttributeCarrier)((Object)privKey);
                DERBMPString nm2 = (DERBMPString)bagAttrs2.getBagAttribute(pkcs_9_at_friendlyName);
                if (nm2 == null || !nm2.getString().equals(name)) {
                    bagAttrs2.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString(name));
                }
                if (bagAttrs2.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                    Certificate ct = this.engineGetCertificate(name);
                    bagAttrs2.setBagAttribute(pkcs_9_at_localKeyId, this.createSubjectKeyId(ct.getPublicKey()));
                }
                Enumeration e2 = bagAttrs2.getBagAttributeKeys();
                while (e2.hasMoreElements()) {
                    ASN1ObjectIdentifier oid2 = (ASN1ObjectIdentifier)e2.nextElement();
                    ASN1EncodableVector kSeq = new ASN1EncodableVector();
                    kSeq.add(oid2);
                    kSeq.add(new DERSet(bagAttrs2.getBagAttribute(oid2)));
                    attrSet = true;
                    kName.add(new DERSequence(kSeq));
                }
            }
            if (!attrSet) {
                ASN1EncodableVector kSeq = new ASN1EncodableVector();
                Certificate ct = this.engineGetCertificate(name);
                kSeq.add(pkcs_9_at_localKeyId);
                kSeq.add(new DERSet(this.createSubjectKeyId(ct.getPublicKey())));
                kName.add(new DERSequence(kSeq));
                kSeq = new ASN1EncodableVector();
                kSeq.add(pkcs_9_at_friendlyName);
                kSeq.add(new DERSet(new DERBMPString(name)));
                kName.add(new DERSequence(kSeq));
            }
            SafeBag kBag = new SafeBag(pkcs8ShroudedKeyBag, kInfo.toASN1Primitive(), new DERSet(kName));
            keyS.add(kBag);
        }
        byte[] keySEncoded = new DERSequence(keyS).getEncoded("DER");
        BEROctetString keyString = new BEROctetString(keySEncoded);
        byte[] cSalt = new byte[20];
        this.random.nextBytes(cSalt);
        ASN1EncodableVector certSeq = new ASN1EncodableVector();
        PKCS12PBEParams cParams = new PKCS12PBEParams(cSalt, 1024);
        AlgorithmIdentifier cAlgId = new AlgorithmIdentifier(this.certAlgorithm, cParams.toASN1Primitive());
        ConcurrentHashMap<Certificate, Certificate> doneCerts = new ConcurrentHashMap<Certificate, Certificate>();
        Enumeration<Object> cs = this.keys.keys();
        while (cs.hasMoreElements()) {
            try {
                String name = cs.nextElement();
                cert = this.engineGetCertificate(name);
                boolean cAttrSet = false;
                cBag = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
                fName = new ASN1EncodableVector();
                if (cert instanceof PKCS12BagAttributeCarrier) {
                    bagAttrs = (PKCS12BagAttributeCarrier)((Object)cert);
                    nm = (DERBMPString)bagAttrs.getBagAttribute(pkcs_9_at_friendlyName);
                    if (nm == null || !nm.getString().equals(name)) {
                        bagAttrs.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString(name));
                    }
                    if (bagAttrs.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                        bagAttrs.setBagAttribute(pkcs_9_at_localKeyId, this.createSubjectKeyId(cert.getPublicKey()));
                    }
                    e = bagAttrs.getBagAttributeKeys();
                    while (e.hasMoreElements()) {
                        oid = (ASN1ObjectIdentifier)e.nextElement();
                        fSeq2 = new ASN1EncodableVector();
                        fSeq2.add(oid);
                        fSeq2.add(new DERSet(bagAttrs.getBagAttribute(oid)));
                        fName.add(new DERSequence(fSeq2));
                        cAttrSet = true;
                    }
                }
                if (!cAttrSet) {
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs_9_at_localKeyId);
                    fSeq.add(new DERSet(this.createSubjectKeyId(cert.getPublicKey())));
                    fName.add(new DERSequence(fSeq));
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs_9_at_friendlyName);
                    fSeq.add(new DERSet(new DERBMPString(name)));
                    fName.add(new DERSequence(fSeq));
                }
                sBag = new SafeBag(certBag, cBag.toASN1Primitive(), new DERSet(fName));
                certSeq.add(sBag);
                doneCerts.put(cert, cert);
            }
            catch (CertificateEncodingException e3) {
                throw new IOException("Error encoding certificate: " + e3.toString());
            }
        }
        cs = this.certs.keys();
        while (cs.hasMoreElements()) {
            try {
                certId = cs.nextElement();
                cert = (Certificate)this.certs.get((String)certId);
                boolean cAttrSet = false;
                if (this.keys.get((String)certId) != null) continue;
                cBag = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
                fName = new ASN1EncodableVector();
                if (cert instanceof PKCS12BagAttributeCarrier) {
                    bagAttrs = (PKCS12BagAttributeCarrier)((Object)cert);
                    nm = (DERBMPString)bagAttrs.getBagAttribute(pkcs_9_at_friendlyName);
                    if (nm == null || !nm.getString().equals(certId)) {
                        bagAttrs.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString((String)certId));
                    }
                    e = bagAttrs.getBagAttributeKeys();
                    while (e.hasMoreElements()) {
                        oid = (ASN1ObjectIdentifier)e.nextElement();
                        if (oid.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                        fSeq2 = new ASN1EncodableVector();
                        fSeq2.add(oid);
                        fSeq2.add(new DERSet(bagAttrs.getBagAttribute(oid)));
                        fName.add(new DERSequence(fSeq2));
                        cAttrSet = true;
                    }
                }
                if (!cAttrSet) {
                    fSeq = new ASN1EncodableVector();
                    fSeq.add(pkcs_9_at_friendlyName);
                    fSeq.add(new DERSet(new DERBMPString((String)certId)));
                    fName.add(new DERSequence(fSeq));
                }
                sBag = new SafeBag(certBag, cBag.toASN1Primitive(), new DERSet(fName));
                certSeq.add(sBag);
                doneCerts.put(cert, cert);
            }
            catch (CertificateEncodingException e4) {
                throw new IOException("Error encoding certificate: " + e4.toString());
            }
        }
        cs = this.chainCerts.keys();
        while (cs.hasMoreElements()) {
            try {
                certId = (CertId)cs.nextElement();
                cert = this.chainCerts.get(certId);
                if (doneCerts.get(cert) != null) continue;
                CertBag cBag2 = new CertBag(x509Certificate, new DEROctetString(cert.getEncoded()));
                ASN1EncodableVector fName2 = new ASN1EncodableVector();
                if (cert instanceof PKCS12BagAttributeCarrier) {
                    PKCS12BagAttributeCarrier bagAttrs3 = (PKCS12BagAttributeCarrier)((Object)cert);
                    Enumeration e5 = bagAttrs3.getBagAttributeKeys();
                    while (e5.hasMoreElements()) {
                        ASN1ObjectIdentifier oid3 = (ASN1ObjectIdentifier)e5.nextElement();
                        if (oid3.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                        ASN1EncodableVector fSeq3 = new ASN1EncodableVector();
                        fSeq3.add(oid3);
                        fSeq3.add(new DERSet(bagAttrs3.getBagAttribute(oid3)));
                        fName2.add(new DERSequence(fSeq3));
                    }
                }
                SafeBag sBag2 = new SafeBag(certBag, cBag2.toASN1Primitive(), new DERSet(fName2));
                certSeq.add(sBag2);
            }
            catch (CertificateEncodingException e6) {
                throw new IOException("Error encoding certificate: " + e6.toString());
            }
        }
        byte[] certSeqEncoded = new DERSequence(certSeq).getEncoded("DER");
        byte[] certBytes = this.cryptData(true, cAlgId, password, false, certSeqEncoded);
        EncryptedData cInfo = new EncryptedData(data, cAlgId, new BEROctetString(certBytes));
        ContentInfo[] info = new ContentInfo[]{new ContentInfo(data, keyString), new ContentInfo(encryptedData, cInfo.toASN1Primitive())};
        AuthenticatedSafe auth = new AuthenticatedSafe(info);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream asn1Out = useDEREncoding ? new DEROutputStream(bOut) : new BEROutputStream(bOut);
        asn1Out.writeObject(auth);
        byte[] pkg = bOut.toByteArray();
        ContentInfo mainInfo = new ContentInfo(data, new BEROctetString(pkg));
        byte[] mSalt = new byte[20];
        int itCount = 1024;
        this.random.nextBytes(mSalt);
        byte[] data = ((ASN1OctetString)mainInfo.getContent()).getOctets();
        try {
            byte[] res = PKCS12KeyStoreSpi.calculatePbeMac(id_SHA1, mSalt, itCount, password, false, data);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(id_SHA1, DERNull.INSTANCE);
            DigestInfo dInfo = new DigestInfo(algId, res);
            mData = new MacData(dInfo, mSalt, itCount);
        }
        catch (Exception e7) {
            throw new IOException("error constructing MAC: " + e7.toString());
        }
        Pfx pfx = new Pfx(mainInfo, mData);
        asn1Out = useDEREncoding ? new DEROutputStream(stream) : new BEROutputStream(stream);
        asn1Out.writeObject(pfx);
    }

    private static byte[] calculatePbeMac(ASN1ObjectIdentifier oid, byte[] salt, int itCount, char[] password, boolean wrongPkcs12Zero, byte[] data) throws Exception {
        SecretKeyFactory keyFact = SecretKeyFactory.getInstance(oid.getId(), bcProvider);
        PBEParameterSpec defParams = new PBEParameterSpec(salt, itCount);
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        BCPBEKey key = (BCPBEKey)keyFact.generateSecret(pbeSpec);
        key.setTryWrongPKCS12Zero(wrongPkcs12Zero);
        Mac mac = Mac.getInstance(oid.getId(), bcProvider);
        mac.init(key, defParams);
        mac.update(data);
        return mac.doFinal();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IgnoresCaseHashtable {
        private ConcurrentHashMap<String, Object> orig = new ConcurrentHashMap();
        private ConcurrentHashMap<Object, String> keys = new ConcurrentHashMap();

        private IgnoresCaseHashtable() {
        }

        public void put(String key, Object value) {
            if (key != null) {
                String lower = Strings.toLowerCase(key);
                String k = this.keys.get(lower);
                if (k != null) {
                    this.orig.remove(k);
                }
                this.keys.put(lower, key);
                this.orig.put(key, value);
            }
        }

        public Enumeration<String> keys() {
            return this.orig.keys();
        }

        public Object remove(String alias) {
            if (alias == null) {
                return null;
            }
            String k = this.keys.remove(Strings.toLowerCase(alias));
            if (k == null) {
                return null;
            }
            return this.orig.remove(k);
        }

        public Object get(String alias) {
            if (alias == null) {
                return null;
            }
            String k = this.keys.get(Strings.toLowerCase(alias));
            if (k == null) {
                return null;
            }
            return this.orig.get(k);
        }

        public Enumeration elements() {
            return this.orig.elements();
        }
    }

    public static class DefPKCS12KeyStore3DES
    extends PKCS12KeyStoreSpi {
        public DefPKCS12KeyStore3DES() {
            super(null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    public static class DefPKCS12KeyStore
    extends PKCS12KeyStoreSpi {
        public DefPKCS12KeyStore() {
            super(null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd40BitRC2_CBC);
        }
    }

    public static class BCPKCS12KeyStore3DES
    extends PKCS12KeyStoreSpi {
        public BCPKCS12KeyStore3DES() {
            super(bcProvider, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    public static class BCPKCS12KeyStore
    extends PKCS12KeyStoreSpi {
        public BCPKCS12KeyStore() {
            super(bcProvider, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd40BitRC2_CBC);
        }
    }

    private class CertId {
        byte[] id;

        CertId(PublicKey key) {
            this.id = PKCS12KeyStoreSpi.this.createSubjectKeyId(key).getKeyIdentifier();
        }

        CertId(byte[] id) {
            this.id = id;
        }

        public int hashCode() {
            return Arrays.hashCode(this.id);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CertId)) {
                return false;
            }
            CertId cId = (CertId)o;
            return Arrays.areEqual(this.id, cId.id);
        }
    }
}

