/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.system.logging.LoggerManager;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import java.util.Formatter;

final class RSACardDummyPrivateKey
implements RSAPrivateCrtKey {
    private static final long serialVersionUID = -7022768737735825315L;
    private final RSAPrivateCrtKey privateKeyRef;
    private final byte[] pkcs8EncodedBytes;
    final byte[] jniEncodedBytes;
    final int moduleBytesLength;
    final String jniEncodedBytesMD5;
    final String modulus;

    public RSACardDummyPrivateKey(RSAPrivateCrtKey privateKeyRef) throws CryptoException {
        if (privateKeyRef == null) {
            throw new CryptoParameterException("missing privateKeyRef");
        }
        this.privateKeyRef = privateKeyRef;
        this.jniEncodedBytes = this.buildEncodedBytes(privateKeyRef);
        this.moduleBytesLength = (7 + privateKeyRef.getModulus().bitLength()) / 8;
        this.jniEncodedBytesMD5 = NumberHelper.md5(this.jniEncodedBytes);
        this.modulus = privateKeyRef.getModulus().toString(16);
        try {
            this.pkcs8EncodedBytes = privateKeyRef.getEncoded();
        }
        catch (Exception e) {
            throw new CryptoParameterException("invalid privateKeyRef with pkcs8EncodedBytes", e);
        }
    }

    public String getAlgorithm() {
        return this.privateKeyRef.getAlgorithm();
    }

    public String getFormat() {
        return this.privateKeyRef.getFormat();
    }

    public byte[] getEncoded() {
        return this.pkcs8EncodedBytes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.jniEncodedBytes);
        result = 31 * result + this.moduleBytesLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RSACardDummyPrivateKey other = (RSACardDummyPrivateKey)obj;
        if (!Arrays.equals(this.jniEncodedBytes, other.jniEncodedBytes)) {
            return false;
        }
        return this.moduleBytesLength == other.moduleBytesLength;
    }

    public String toString() {
        Formatter builder = new Formatter();
        builder.format("DummyRSAPrivateKey ", new Object[0]);
        try {
            if (this.privateKeyRef instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey k = this.privateKeyRef;
                builder.format("\n%8s%20s=0x%s", "", "Modulus", k.getModulus().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PublicExponent", k.getPublicExponent().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PrivateExponent", k.getPrivateExponent().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PrimeP", k.getPrimeP().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PrimeQ", k.getPrimeQ().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PrimeExponentP", k.getPrimeExponentP().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PrimeExponentQ", k.getPrimeExponentQ().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "CrtCoefficient", k.getCrtCoefficient().toString(16));
            } else {
                builder.format("\n%8s%20s=0x%s", "", "Modulus", this.privateKeyRef.getModulus().toString(16));
                builder.format("\n%8s%20s=0x%s", "", "PrivateExponent", this.privateKeyRef.getPrivateExponent().toString(16));
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("DummyRSAPrivateKey dump detail invalid", (Throwable)e);
            builder.format("\n%8s%20s=0x%s", "", "k", "failure");
        }
        builder.format("\n%4s%20s=0x%s", "", "jniEncodedBytes", DataHelper.toHexString(this.jniEncodedBytes));
        builder.format("\n%4s%20s=%s", "", "moduleBytesLength", this.moduleBytesLength);
        String output = builder.toString();
        builder.close();
        return output;
    }

    private byte[] buildEncodedBytes(RSAPrivateKey privateKey) throws CryptoException {
        byte[] jniEncodedBytes = null;
        try {
            byte[] data = privateKey.getEncoded();
            ASN1Sequence s = ASN1Sequence.getInstance(data);
            byte[] octetStr = s.getObjectAt(2).toASN1Primitive().getEncoded();
            int len = octetStr[1] & 0x7F;
            int ret_len = octetStr.length - len - 2;
            jniEncodedBytes = new byte[ret_len];
            System.arraycopy(octetStr, len + 2, jniEncodedBytes, 0, ret_len);
        }
        catch (Exception e) {
            throw new CryptoException("buildEncodedBytes failure", e);
        }
        return jniEncodedBytes;
    }

    public BigInteger getPrivateExponent() {
        return this.privateKeyRef.getPrivateExponent();
    }

    public BigInteger getModulus() {
        return this.privateKeyRef.getModulus();
    }

    public String dumpPublicKey() {
        return String.format("(bitLength=%d, md5=%s, modulus=%s)", this.moduleBytesLength << 3, this.jniEncodedBytesMD5, this.modulus);
    }

    public RSAPrivateKey getPrivateKeyRef() {
        return this.privateKeyRef;
    }

    public BigInteger getPublicExponent() {
        return this.privateKeyRef.getPublicExponent();
    }

    public BigInteger getPrimeP() {
        return this.privateKeyRef.getPrimeP();
    }

    public BigInteger getPrimeQ() {
        return this.privateKeyRef.getPrimeQ();
    }

    public BigInteger getPrimeExponentP() {
        return this.privateKeyRef.getPrimeExponentP();
    }

    public BigInteger getPrimeExponentQ() {
        return this.privateKeyRef.getPrimeExponentQ();
    }

    public BigInteger getCrtCoefficient() {
        return this.privateKeyRef.getCrtCoefficient();
    }
}

