/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.common;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.sadk.signature.PKCS7PackageFacade;
import cfca.sadk.signature.decoder.PKCS7DecodeFacade;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.InputStream;

public class PKCS7SignedData {
    private Session session = null;
    private PKCS7DecodeFacade p7Decoder = null;

    public PKCS7SignedData(Session session) {
        this.session = session;
    }

    public byte[] packageSignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] encryptData, Mechanism digestAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        try {
            return PKCS7PackageFacade.packageSignedData(ifAttach, contentType, sourceData, encryptData, digestAlgorithm, receiverCerts);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("build signedData failure", e);
        }
    }

    public void loadDERData(byte[] data) throws PKIException {
        this.p7Decoder = new PKCS7DecodeFacade(this.session, data);
    }

    public void loadBase64(byte[] data) throws PKIException {
        this.p7Decoder = new PKCS7DecodeFacade(this.session, data);
    }

    public SignedData getSignedData() {
        return this.p7Decoder == null ? null : this.p7Decoder.getSignedData();
    }

    public boolean verifyP7SignedDataAttach() throws PKIException {
        return this.p7Decoder == null ? false : this.p7Decoder.verifyP7SignedDataAttach();
    }

    public byte[] getSourceData() throws PKIException {
        return this.p7Decoder == null ? null : this.p7Decoder.getSourceData();
    }

    public X509Cert getSignerX509Cert() throws PKIException {
        return this.p7Decoder == null ? null : this.p7Decoder.getSignerX509Cert();
    }

    public boolean verifyP7SignedData(InputStream sourceFileStream) throws PKIException {
        return this.p7Decoder == null ? false : this.p7Decoder.verifyP7SignedData(sourceFileStream);
    }

    public boolean verifyP7SignedData(byte[] sourceData) throws PKIException {
        return this.p7Decoder == null ? false : this.p7Decoder.verifyP7SignedData(sourceData);
    }

    public byte[] getSignature() throws PKIException {
        return this.p7Decoder == null ? null : this.p7Decoder.getSignature();
    }

    public String getDigestAlgorithm() throws PKIException {
        return this.p7Decoder == null ? null : this.p7Decoder.getDigestAlgorithm();
    }

    public boolean verifyP7SignedDataByHash(byte[] sourceHash) throws PKIException {
        return this.p7Decoder == null ? false : this.p7Decoder.verifyP7SignedDataByHash(sourceHash);
    }

    public final String getSignTime() throws PKIException {
        return this.p7Decoder == null ? null : this.p7Decoder.getSignTime();
    }
}

