/*
 * Decompiled with CFR 0.152.
 */
package cfca.logback.util;

import cfca.ch.qos.logback.classic.LoggerContext;
import cfca.ch.qos.logback.classic.joran.JoranConfigurator;
import cfca.ch.qos.logback.core.joran.spi.JoranException;
import cfca.logback.util.Environments;
import cfca.org.slf4j.ILoggerFactory;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import java.io.File;

public final class LogbackInitializer {
    private static final Logger commonLogger = LoggerFactory.getLogger(LogbackInitializer.class);
    private static final Logger environmentLogger = LoggerFactory.getLogger("environmentLogger");

    private LogbackInitializer() {
    }

    public static final synchronized void setLogback(String logbackFilePath) throws Exception {
        LogbackInitializer.setLogback(logbackFilePath, null, null);
    }

    public static final synchronized void setLogback(String logbackFilePath, String applicationName) throws Exception {
        LogbackInitializer.setLogback(logbackFilePath, applicationName, null);
    }

    public static final synchronized void setLogback(String logbackFilePath, String applicationName, String contextName) throws Exception {
        StringBuilder builder = Environments.environments().build();
        builder.append("\n logback-xml-path: " + logbackFilePath);
        builder.append("\n");
        environmentLogger.info("setLogback running {}", (Object)builder);
        if (logbackFilePath == null) {
            commonLogger.error("logback-cfca.xml path is null");
            throw new Exception("logback-cfca.xml path is null");
        }
        File file = new File(logbackFilePath);
        String absolutePath = file.getAbsolutePath();
        if (!file.exists()) {
            commonLogger.error("logback-cfca.xml file not exists: {}", (Object)absolutePath);
            throw new Exception("logback-cfca.xml file not exists: " + absolutePath);
        }
        if (!file.isFile()) {
            commonLogger.error("logback-cfca.xml path not file: {}", (Object)absolutePath);
            throw new Exception("logback-cfca.xml path not file: " + absolutePath);
        }
        environmentLogger.info("setLogback running logback-cfca.xml: {}", (Object)absolutePath);
        try {
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            LoggerContext lc = (LoggerContext)loggerFactory;
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(lc);
            lc.reset();
            lc.putProperty("application-name", applicationName == null ? "" : applicationName);
            if (contextName != null) {
                lc.setName(contextName);
            }
            configurator.doConfigure(file.getAbsolutePath());
        }
        catch (JoranException e) {
            commonLogger.error("logback config failed: {}", (Object)absolutePath, (Object)e);
            throw new Exception("logback config failed: " + absolutePath, e);
        }
        environmentLogger.info("setLogback finished {}", (Object)builder);
        environmentLogger.info("setLogback finished logback-cfca.xml: {}", (Object)absolutePath);
        commonLogger.info("setLogback finished {}", (Object)builder);
        commonLogger.info("setLogback finished logback-cfca.xml: {}", (Object)absolutePath);
    }
}

