/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.tx.corpquery;

import com.alibaba.fastjson.JSONObject;
import cpcn.dsp.institution.api.tx.TxBaseResponse;
import cpcn.dsp.institution.api.util.JSONUtil;
import cpcn.dsp.institution.api.vo.brief.Beneficiary;
import cpcn.dsp.institution.api.vo.brief.EntInfo;
import cpcn.dsp.institution.api.vo.brief.Graph;
import cpcn.dsp.institution.api.vo.brief.Path;
import java.util.List;

public class Tx1275Response
extends TxBaseResponse {
    private String institutionID;
    private String txSN;
    private String traceNo;
    private String responseCode;
    private String responseMessage;
    private String status;
    private EntInfo entInfo;
    private List<Beneficiary> beneficiaryList;
    private List<Path> paths;
    private Graph graph;

    public Tx1275Response(String responseMessage, String responseSignature) throws Exception {
        super(responseMessage, responseSignature);
    }

    public Tx1275Response(String responseMessage, String responseSignature, String responseDgtlEnvlp, String responseSignSN, String responseEncryptSN) throws Exception {
        super(responseMessage, responseSignature, responseDgtlEnvlp, responseSignSN, responseEncryptSN);
    }

    @Override
    protected void process(String document) throws Exception {
        if ("2000".equals(this.code)) {
            JSONObject jsonObject = JSONObject.parseObject((String)document);
            this.institutionID = jsonObject.getString("InstitutionID");
            this.txSN = jsonObject.getString("TxSN");
            this.traceNo = jsonObject.getString("TraceNo");
            this.responseCode = jsonObject.getString("ResponseCode");
            this.responseMessage = jsonObject.getString("ResponseMessage");
            this.entInfo = this.processEntInfo(jsonObject);
            this.beneficiaryList = this.processBeneficiaryList(jsonObject);
            this.paths = this.processPaths(jsonObject);
            this.graph = this.processGraphs(jsonObject);
        }
    }

    private Graph processGraphs(JSONObject jsonObject) {
        return JSONUtil.toBean(jsonObject.getString("Graph"), Graph.class);
    }

    private List<Path> processPaths(JSONObject jsonObject) {
        return JSONUtil.toList(jsonObject.getString("Paths"), Path.class);
    }

    private List<Beneficiary> processBeneficiaryList(JSONObject jsonObject) {
        return JSONUtil.toList(jsonObject.getString("BeneficiaryList"), Beneficiary.class);
    }

    private EntInfo processEntInfo(JSONObject jsonObject) {
        return JSONUtil.toBean(jsonObject.getString("EntInfo"), EntInfo.class);
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public void setInstitutionID(String institutionID) {
        this.institutionID = institutionID;
    }

    public String getTxSN() {
        return this.txSN;
    }

    public void setTxSN(String txSN) {
        this.txSN = txSN;
    }

    public String getTraceNo() {
        return this.traceNo;
    }

    public void setTraceNo(String traceNo) {
        this.traceNo = traceNo;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public EntInfo getEntInfo() {
        return this.entInfo;
    }

    public void setEntInfo(EntInfo entInfo) {
        this.entInfo = entInfo;
    }

    public List<Beneficiary> getBeneficiaryList() {
        return this.beneficiaryList;
    }

    public void setBeneficiaryList(List<Beneficiary> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    public void setPaths(List<Path> paths) {
        this.paths = paths;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }
}

