/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.security;

import cpcn.dsp.institution.api.security.Aes256Util;
import cpcn.dsp.institution.api.security.SecurityUtil;
import cpcn.dsp.institution.api.security.Verifier;
import cpcn.dsp.institution.api.util.StringUtil;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;

public class PublicKeyVerifier
implements Verifier {
    private PublicKey publicKey;
    private String algorithm = "SHA1withRSA";
    private String serialNO;

    public PublicKeyVerifier(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PublicKeyVerifier(PublicKey publicKey, String algorithm) {
        this.publicKey = publicKey;
        this.algorithm = algorithm;
    }

    public PublicKeyVerifier(X509Certificate x509Certificate, String algorithm) throws Exception {
        this.publicKey = x509Certificate.getPublicKey();
        this.algorithm = algorithm;
        this.serialNO = String.valueOf(x509Certificate.getSerialNumber());
    }

    @Override
    public boolean verify(String message, String signature) throws Exception {
        byte[] bytes = StringUtil.hex2bytes(signature);
        Signature sig = Signature.getInstance(this.algorithm);
        sig.initVerify(this.publicKey);
        sig.update(message.getBytes("UTF-8"));
        return sig.verify(bytes);
    }

    @Override
    public boolean verify(byte[] data, byte[] signature) throws Exception {
        Signature sig = Signature.getInstance(this.algorithm);
        sig.initVerify(this.publicKey);
        sig.update(data);
        return sig.verify(signature);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public String symmetricEncrypt(String message, String symmetricCipher) throws Exception {
        return Aes256Util.encode(message, symmetricCipher);
    }

    @Override
    public String getSN() throws Exception {
        return this.serialNO;
    }

    @Override
    public String asymmetricEncrypt(byte[] message) throws Exception {
        return SecurityUtil.encryptByRSA(message, this.publicKey);
    }
}

