/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.security;

import cfca.sadk.x509.certificate.X509Cert;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class PfxHelper {
    private PrivateKey privateKey;
    private X509Certificate x509Certificate;
    private String serialNO;

    public PfxHelper(String pfxfilename, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        FileInputStream fis = new FileInputStream(pfxfilename);
        keyStore.load(fis, password.toCharArray());
        fis.close();
        Enumeration<String> aliases = keyStore.aliases();
        String alias = aliases.nextElement();
        this.privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        this.x509Certificate = (X509Certificate)keyStore.getCertificate(alias);
        this.serialNO = String.valueOf(this.x509Certificate.getSerialNumber());
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public void setX509Certificate(X509Certificate x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    public String getSerialNO() {
        return this.serialNO;
    }

    public void setSerialNO(String serialNO) {
        this.serialNO = serialNO;
    }

    public static void main(String[] args) {
        try {
            PfxHelper p = new PfxHelper("F:/rsa.pfx", "cfca1234");
            System.out.println(p.getSerialNO());
            X509Cert x509Cert = new X509Cert("F:/rsa.cer");
            System.out.println(x509Cert.getStringSerialNumber());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

