/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.security;

import cpcn.dsp.institution.api.security.DigitalEnvelopeUtil;
import cpcn.dsp.institution.api.security.PfxHelper;
import cpcn.dsp.institution.api.security.RandomCipherGenerateUtil;
import cpcn.dsp.institution.api.security.SecurityUtil;
import cpcn.dsp.institution.api.security.Signer;
import cpcn.dsp.institution.api.util.StringUtil;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;

public class PfxSigner
implements Signer {
    private PrivateKey privateKey;
    private String algorithm = "SHA1withRSA";
    private String serialNo;
    private X509Certificate x509Certificate;

    public PfxSigner(String pfxFile, String password) throws Exception {
        this(pfxFile, password, "SHA1withRSA");
    }

    public PfxSigner(String pfxFile, String password, String algorithm) throws Exception {
        PfxHelper pfxHelper = new PfxHelper(pfxFile, password);
        this.privateKey = pfxHelper.getPrivateKey();
        this.algorithm = algorithm;
        this.serialNo = pfxHelper.getSerialNO();
        this.x509Certificate = pfxHelper.getX509Certificate();
    }

    @Override
    public String sign(String message) throws Exception {
        Signature signature = Signature.getInstance(this.algorithm);
        signature.initSign(this.privateKey);
        signature.update(message.getBytes("UTF-8"));
        return StringUtil.bytes2hex(signature.sign());
    }

    @Override
    public byte[] sign(byte[] bytes) throws Exception {
        Signature signature = Signature.getInstance(this.algorithm);
        signature.initSign(this.privateKey);
        signature.update(bytes);
        return signature.sign();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public byte[] sign(byte[] bytes, String algorithm) throws Exception {
        Signature signature = Signature.getInstance(algorithm);
        signature.initSign(this.privateKey);
        signature.update(bytes);
        return signature.sign();
    }

    @Override
    public String decrypt(String message, String digitalEnvelope) throws Exception {
        String key = SecurityUtil.getDecryptKeyByteByRSA(digitalEnvelope, this.privateKey);
        return DigitalEnvelopeUtil.generatePlainText(key, message, this.privateKey.getAlgorithm());
    }

    @Override
    public String decrpt(String message) throws Exception {
        return SecurityUtil.getDecryptKeyByteByRSA(message, this.privateKey);
    }

    @Override
    public String getSN() throws Exception {
        return this.serialNo;
    }

    @Override
    public String getSymmetricCipher() throws Exception {
        return RandomCipherGenerateUtil.randomHexString(32);
    }

    @Override
    public String getAlgorithmType() throws Exception {
        return this.x509Certificate.getSigAlgName();
    }
}

